/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.AbstractEventWriter;
import com.splunk.collect.EventPartitioner;
import com.splunk.collect.EventWriter;
import com.splunk.collect.EventWriterFactory;
import com.splunk.collect.NoOpEventWriter;
import com.splunk.s2s.Channel;
import com.splunk.s2s.Event;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class IndexProcessor
extends AbstractEventWriter
implements Runnable {
    private static Logger gLogger = Logger.getLogger(IndexProcessor.class);
    private static final Event FINISH_EVENT = new Event();
    public static final String BASENAME_PARSED = "hunk_pv1";
    public static final String BASENAME_RAW = "hunk_rv1";
    Map<String, EventWriter> _parsedWriters = new HashMap<String, EventWriter>();
    NoOpEventWriter _devNullEW = null;
    EventPartitioner _eventPartitioner;
    ConcurrentLinkedQueue<Channel> _channels2drop = null;
    LinkedBlockingQueue<Event> _events = null;
    long _autoCommitPeriodMs = 30000L;
    long _autoClosePeriodMs = 300000L;
    long _parsedHardMaxRawBytes = 0x100000000L;
    long _rawSoftMaxRawBytes = 0x80000000L;
    long _rawHardMaxRawBytes = 0x100000000L;
    Path _homeDir = null;
    Thread _t = null;
    EventWriterFactory _ewf = null;
    Configuration _conf = null;
    final String _name;
    final String _outputType;

    public static boolean isHunkEventFile(Path p) {
        return p.getName().startsWith("hunk_p");
    }

    public static boolean isHunkRawFile(Path p) {
        return p.getName().startsWith("hunk_r");
    }

    public IndexProcessor(boolean trackEvents, String name, Configuration conf, Path basedir, EventWriterFactory ewf, String partionFormat, String outputType) {
        super(trackEvents);
        this._name = name;
        this._conf = conf;
        this._channels2drop = new ConcurrentLinkedQueue();
        this._events = new LinkedBlockingQueue(5000);
        this._ewf = ewf;
        this._eventPartitioner = new EventPartitioner(partionFormat);
        this._devNullEW = new NoOpEventWriter(trackEvents);
        this._outputType = outputType;
        if (null != basedir) {
            this._homeDir = new Path(basedir, name);
        }
        if (this._outputType != null) {
            this._t = new Thread((Runnable)this, "IndexWriter name=" + name);
            this._t.start();
        }
    }

    public void join() throws InterruptedException {
        this._t.join();
    }

    @Override
    public synchronized void commit() {
        super.commit();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setRawSoftMaxBytes(long maxBytes) {
        this._rawSoftMaxRawBytes = maxBytes;
    }

    public void setRawHardMaxBytes(long maxBytes) {
        this._rawHardMaxRawBytes = maxBytes;
    }

    public void setParsedMaxBytes(long maxBytes) {
        this._parsedHardMaxRawBytes = maxBytes;
    }

    @Override
    public void addEventImpl(Event e) throws IOException {
        if (!this._channels2drop.isEmpty()) {
            while (!this._events.isEmpty()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Channel c = null;
            while ((c = this._channels2drop.poll()) != null) {
                for (EventWriter ew : this._parsedWriters.values()) {
                    ew.gotDropChannel(c);
                }
            }
        }
        try {
            this._events.put(e);
        }
        catch (InterruptedException ex) {
            gLogger.warn((Object)"Interrupted while adding event", (Throwable)ex);
        }
    }

    @Override
    public void run() {
        Event e = null;
        try {
            StringBuilder buf = new StringBuilder(128);
            while (true) {
                if ((e = this._events.poll(1L, TimeUnit.SECONDS)) == null) {
                    this.autoCommitOrCloseIfNecessary(buf);
                }
                if (e == null) continue;
                if (e == FINISH_EVENT) {
                    break;
                }
                this.getEventWriter(e).addEvent(e);
                this.autoCommitOrCloseIfNecessary(buf);
            }
        }
        catch (InterruptedException ex) {
            gLogger.warn((Object)"Interrupted while processing events", (Throwable)ex);
        }
        catch (Throwable th) {
            gLogger.error((Object)"Error while processing events", th);
        }
        finally {
            this.commit();
            this.closeWriters();
        }
    }

    private boolean shouldCloseWriter(EventWriter ew, long maxBytes, boolean checkIdleTime, StringBuilder reason) {
        reason.setLength(0);
        long lastAddEvent = ew.getLastAddEventTime();
        if (lastAddEvent == 0L) {
            return false;
        }
        if (ew.getRawEventBytes() > maxBytes) {
            reason.append("Max size reached: size=").append(ew.getRawEventBytes());
            reason.append(", limit=").append(maxBytes);
            return true;
        }
        if (!checkIdleTime) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - lastAddEvent;
        if (elapsed > this._autoClosePeriodMs) {
            reason.append("Max idle time reached: idle_time=").append(elapsed);
            reason.append(", limit=").append(this._autoClosePeriodMs);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoCommitOrCloseIfNecessary(StringBuilder buffer) {
        if (System.currentTimeMillis() - this.getLastCommitTime() > this._autoCommitPeriodMs) {
            this.commit();
        }
        Iterator<Map.Entry<String, EventWriter>> iter = this._parsedWriters.entrySet().iterator();
        while (iter.hasNext()) {
            EventWriter ew = iter.next().getValue();
            if (!this.shouldCloseWriter(ew, this._parsedHardMaxRawBytes, true, buffer)) continue;
            gLogger.info((Object)("Closing parsed writer,name=" + ew.getName() + ", reason=" + buffer));
            try {
                ew.close();
            }
            catch (IOException ex) {
                gLogger.warn((Object)"Problem closing writer", (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly((Closeable)ew);
            }
            iter.remove();
        }
    }

    private EventWriter getEventWriter(Event e) {
        if (e.isParsedEvent()) {
            String key = this._eventPartitioner.getLookupKey(e);
            EventWriter ew = this._parsedWriters.get(key);
            if (null == ew) {
                if (this._outputType.equals("hdfs")) {
                    Path dir = this._eventPartitioner.getDirectory(e, this._homeDir);
                    ew = this._ewf.getHadoopEventWriter(this._conf, false, dir, BASENAME_PARSED);
                    this._parsedWriters.put(key, ew);
                } else if (this._outputType.equals("kafka")) {
                    ew = this._ewf.getKafkaEventWriter(this._conf, this._eventPartitioner.getKafkaPartitionKey(e));
                    this._parsedWriters.put(key, ew);
                }
            }
            return ew;
        }
        return this._devNullEW;
    }

    @Override
    public void commitImpl() {
        for (EventWriter ew : this._parsedWriters.values()) {
            ew.commit();
        }
    }

    public void closeWriters() {
        for (EventWriter ew : this._parsedWriters.values()) {
            try {
                ew.close();
            }
            catch (IOException ex) {
                gLogger.warn((Object)("Exception while closing writer " + ew.getName()), (Throwable)ex);
            }
        }
    }

    @Override
    public void gotDropChannel(Channel c) {
        this._channels2drop.add(c);
    }

    @Override
    public void close() throws IOException {
        this._events.add(FINISH_EVENT);
    }
}

