/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.data_delivery;

import com.splunk.data_delivery.ConnectionHandler;
import com.splunk.data_delivery.ForwardingHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;

public class S2SStreamingRelay
implements Runnable {
    private static final Logger gLogger = Logger.getLogger(S2SStreamingRelay.class);
    private byte[] bytes;
    private int port;
    private ForwardingHandler handler;
    private long connectionsHandled = 0L;
    private boolean shouldStop = false;

    public S2SStreamingRelay(int port, ForwardingHandler handler) {
        gLogger.info((Object)"Relay constructed");
        this.port = port;
        this.handler = handler;
        this.bytes = this.createHandshakeMessage();
    }

    public long getConnectionsHandled() {
        return this.connectionsHandled;
    }

    public int getPort() {
        return this.port;
    }

    public void terminate() {
        this.shouldStop = true;
    }

    private byte[] createHandshakeMessage() {
        String k = "__s2s_control_msg";
        String v = "cap_response=success;cap_flush_key=true;idx_can_send_hb=true;v4=true;channel_limit=500;ack=false;idx_can_recv_token=true";
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(1);
            dos.writeInt(k.length() + 1);
            dos.write(k.getBytes());
            dos.write(0);
            dos.writeInt(v.length() + 1);
            dos.write(v.getBytes());
            dos.write(0);
            dos.writeInt(0);
            dos.writeInt(5);
            dos.write("_raw".getBytes());
            dos.write(0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        gLogger.info((Object)"Starting the relay....");
        ServerSocket serverSocket = null;
        Socket clientSocket = null;
        try {
            try {
                gLogger.info((Object)("Opening a socket listening on port " + this.port));
                serverSocket = new ServerSocket(this.port, 50, InetAddress.getByName(null));
                serverSocket.setReceiveBufferSize(65536);
                serverSocket.setSoTimeout(1000);
                while (!this.shouldStop) {
                    try {
                        clientSocket = serverSocket.accept();
                    }
                    catch (SocketTimeoutException ex) {
                        continue;
                    }
                    if (null == clientSocket) continue;
                    gLogger.debug((Object)("Got new connection: " + clientSocket));
                    ConnectionHandler ch = new ConnectionHandler(clientSocket, this.bytes, this.handler);
                    ++this.connectionsHandled;
                    ch.start();
                }
            }
            finally {
                gLogger.info((Object)"Relay is shutting down");
                if (null != serverSocket) {
                    serverSocket.close();
                }
                if (null != clientSocket) {
                    clientSocket.close();
                }
            }
        }
        catch (Throwable th) {
            gLogger.error((Object)("Caught throwable while negotiating connections on port " + this.port), th);
        }
    }
}

