/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal.hadoop.mapreduce;

import com.splunk.journal.hadoop.RecordReaderHelper;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.Logger;

public class JournalRecordReader
extends RecordReader<Text, Text> {
    static Logger logger = Logger.getLogger(JournalRecordReader.class);
    RecordReaderHelper helper = new RecordReaderHelper();
    Text key = new Text();
    Text value = new Text();

    public void initialize(InputSplit genericSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration conf = taskAttemptContext.getConfiguration();
        FileSplit fileSplit = (FileSplit)genericSplit;
        Path path = fileSplit.getPath();
        long start = fileSplit.getStart();
        long length = fileSplit.getLength();
        this.helper.initialize(path, start, length, conf);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.helper.nextKeyValue();
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        this.helper.getCurrentKey(this.key);
        return this.key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        this.helper.getCurrentValue(this.value);
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.helper.getProgress();
    }

    public void close() throws IOException {
        this.helper.close();
    }
}

