/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.mr.JobSubmitter;
import com.splunk.mr.SplunkBaseMapper;
import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.SplunkLineRecordReader;
import com.splunk.mr.input.SplunkRecordReaderWrapper;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.ReflectionUtil;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.log4j.Logger;

public class JobSubmitterInputFormat
extends FileInputFormat {
    private static Logger gLogger = Logger.getLogger(JobSubmitterInputFormat.class);
    protected static Pattern MATCH_ALL = Pattern.compile(".*");

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        JobSubmitter js = JobSubmitter.get(job.getConfiguration(), null, null, null);
        return js.getSplits(job.getJobName());
    }

    public BaseSplunkRecordReader createRecordReader(InputSplit split, TaskAttemptContext tac) throws IOException, InterruptedException {
        gLogger.debug((Object)("createRecordReader: " + split));
        VixInputSplit vix = (VixInputSplit)split;
        BaseSplunkRecordReader rr = null;
        try {
            if (!vix.getInputFormatClass().isEmpty()) {
                InputFormat vixIF = (InputFormat)ReflectionUtil.newInstance(vix.getInputFormatClass(), new Object[0]);
                gLogger.info((Object)("using InputFormat class=" + vixIF.getClass().getName() + " to generate record reader for split=" + (Object)((Object)vix)));
                rr = vixIF.createRecordReader(vix.getSplit(), tac);
            } else {
                rr = SplunkBaseMapper.initPreprocessor(tac.getConfiguration(), split, tac.getTaskAttemptID());
            }
            if (rr == null) {
                rr = new SplunkLineRecordReader();
            }
            gLogger.info((Object)String.format("using class=%s to process split=%s", ((Object)((Object)rr)).getClass().getName(), vix.toString()));
            BaseSplunkRecordReader result = null;
            if (rr instanceof BaseSplunkRecordReader) {
                result = rr;
            } else {
                SplunkRecordReaderWrapper wrapper = new SplunkRecordReaderWrapper(rr);
                wrapper.setFilePattern(MATCH_ALL);
                result = wrapper;
            }
            result.initialize(vix, tac);
            vix.setRecordReader(result);
            return result;
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(rr);
            throw ex;
        }
        catch (InterruptedException ex) {
            IOUtils.closeQuietly(rr);
            throw ex;
        }
    }
}

