/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.codehaus.jackson.map.ObjectMapper;

public class CacheInfoFile {
    public static final String CACHE_INFO_FILENAME = "info.json";
    private final FileSystem fs;
    private final ObjectMapper objectMapper;
    private Path cacheInfoFileDir;

    public CacheInfoFile(FileSystem fs) {
        this.fs = fs;
        this.objectMapper = new ObjectMapper();
    }

    public CacheInfoFile withDir(Path cacheInfoFileDir) {
        this.cacheInfoFileDir = cacheInfoFileDir;
        return this;
    }

    public boolean exists() throws IOException {
        return this.fs.exists(this.getInfoFile());
    }

    public Path getInfoFile() {
        if (this.cacheInfoFileDir == null) {
            throw new IllegalStateException("Cache info file dir has to be set before using this class");
        }
        return new Path(this.cacheInfoFileDir, CACHE_INFO_FILENAME);
    }

    public void create(Map<String, String> map) throws IOException {
        FSDataOutputStream open = this.fs.create(this.getInfoFile(), true);
        try {
            IOUtils.write((String)this.objectMapper.writeValueAsString(map), (OutputStream)open);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)open);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> get() throws IOException {
        if (!this.exists()) {
            throw new IOException("CacheInfoFile did not exist");
        }
        FSDataInputStream open = this.fs.open(this.getInfoFile());
        try {
            String json = IOUtils.toString((InputStream)open);
            Map map = (Map)this.objectMapper.readValue(json, Map.class);
            return map;
        }
        finally {
            IOUtils.closeQuietly((InputStream)open);
        }
    }
}

