/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.Cache;
import com.splunk.mr.cache.GetsReferenceFile;
import com.splunk.mr.packaging.IncrementFileCountWhenFileIsStale;
import com.splunk.mr.packaging.SynchronizedExecuter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class CacheReference {
    private static final Logger gLogger = Logger.getLogger(CacheReference.class);
    private static final int UPDATE_TIMEOUT_IN_SECONDS = 15;
    private final FileSystem fs;
    private final GetsReferenceFile getsReferenceFile;
    private final Path newReferenceLock;
    private final Path trashDir;

    public CacheReference(FileSystem fs, GetsReferenceFile getsReferenceFile, Path referenceDir) {
        this.fs = fs;
        this.getsReferenceFile = getsReferenceFile;
        this.newReferenceLock = new Path(referenceDir, "new-ref.lock");
        this.trashDir = new Path(referenceDir, "tmp");
    }

    /*
     * Exception decompiling
     */
    public Cache deref() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void update(CacheUpdate cacheUpdate) throws IOException {
        this.doSync(this.getTransactionFromUpdate(cacheUpdate));
    }

    public void doSync(CacheTransaction cacheTransaction) throws IOException {
        try {
            this.updateSynchronously(cacheTransaction);
        }
        catch (CouldNotDeletePathException e) {
            this.fs.delete(this.newReferenceLock, false);
        }
    }

    private void updateSynchronously(CacheTransaction cacheTransaction) {
        AtomicInteger hasAttemptedToCommitUpdate = new AtomicInteger(0);
        int millisSleepPerTry = 350;
        new SynchronizedExecuter<Path>().executeSynchronized(new DeletingRefLockPathProvider(), new UpdateReferenceOnLockAcquired(cacheTransaction, hasAttemptedToCommitUpdate), new StopRetryAfterTimeoutOrAfterCommitAttempt(hasAttemptedToCommitUpdate), new CreateNewHdfsFile(), millisSleepPerTry);
    }

    private CacheTransaction getTransactionFromUpdate(final CacheUpdate cacheUpdate) {
        return new CacheTransaction(){
            Cache merge;
            final Path mutableReferenceFile;
            {
                this.mutableReferenceFile = new Path(CacheReference.this.trashDir, UUID.randomUUID().toString() + "-new-ref.tmp");
            }

            @Override
            public void prepare(Cache cache) throws IOException {
                this.merge = cache.merge(cacheUpdate);
                this.writeMutableRef(this.merge);
            }

            private void writeMutableRef(Cache cache) throws IOException {
                FSDataOutputStream mutableRefOut = null;
                try {
                    gLogger.debug((Object)("Creating mutable reference file: " + this.mutableReferenceFile));
                    mutableRefOut = CacheReference.this.fs.create(this.mutableReferenceFile, false);
                    String json = cache.toJson();
                    gLogger.debug((Object)("Writing " + json.length() + " bytes to the reference file: " + this.mutableReferenceFile));
                    mutableRefOut.writeBytes(json);
                    mutableRefOut.sync();
                    mutableRefOut.close();
                    gLogger.debug((Object)("Wrote " + CacheReference.this.fs.getFileStatus(this.mutableReferenceFile).getLen() + " bytes to the file: " + this.mutableReferenceFile));
                }
                catch (IOException ioe) {
                    try {
                        gLogger.error((Object)"Error while writing to reference file ", (Throwable)ioe);
                        throw ioe;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(mutableRefOut);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)mutableRefOut);
            }

            @Override
            public void commit() throws IOException {
                Path refPath = CacheReference.this.getsReferenceFile.getNewPath(this.merge);
                gLogger.debug((Object)("Renaming the file " + this.mutableReferenceFile + " to " + refPath));
                if (!CacheReference.this.fs.rename(this.mutableReferenceFile, refPath)) {
                    throw new IOException("Could not rename mutable ref to new ref path");
                }
            }
        };
    }

    private Path getUniqueTrashPath() {
        return new Path(this.trashDir, UUID.randomUUID().toString());
    }

    private static class CouldNotDeletePathException
    extends RuntimeException {
        private CouldNotDeletePathException() {
        }
    }

    private class CreateNewHdfsFile
    implements SynchronizedExecuter.AtomicFactory<Path> {
        private CreateNewHdfsFile() {
        }

        @Override
        public boolean create(Path toCreate) {
            if (CacheReference.this.fs instanceof LocalFileSystem) {
                return this.createByAtomicNewFileCreation(((LocalFileSystem)CacheReference.this.fs).pathToFile(toCreate));
            }
            return this.createByAtomicRename(toCreate);
        }

        private boolean createByAtomicNewFileCreation(File file) {
            try {
                file.getParentFile().mkdirs();
                return file.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean createByAtomicRename(Path toCreate) {
            Path uniqueTrashPath = CacheReference.this.getUniqueTrashPath();
            try {
                if (CacheReference.this.fs.createNewFile(uniqueTrashPath)) {
                    boolean bl = CacheReference.this.fs.rename(uniqueTrashPath, toCreate);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.delete(uniqueTrashPath);
            }
        }

        private void delete(Path uniqueTrashPath) {
            try {
                CacheReference.this.fs.delete(uniqueTrashPath, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class StopRetryAfterTimeoutOrAfterCommitAttempt
    implements SynchronizedExecuter.AbortCondition {
        private final AtomicInteger hasAttemptedToCommitUpdate;
        private final long timeoutSecondsLater = System.currentTimeMillis() + 15000L;

        public StopRetryAfterTimeoutOrAfterCommitAttempt(AtomicInteger hasAttemptedToCommitUpdate) {
            this.hasAttemptedToCommitUpdate = hasAttemptedToCommitUpdate;
        }

        @Override
        public boolean shouldStopRetrying() {
            return this.hasAttemptedToCommitUpdate.get() > 0 || System.currentTimeMillis() > this.timeoutSecondsLater;
        }
    }

    private class UpdateReferenceOnLockAcquired
    implements SynchronizedExecuter.AcquiredHandler<Path> {
        private final CacheTransaction cacheTransaction;
        private final AtomicInteger hasAttemptedToCommitUpdate;

        public UpdateReferenceOnLockAcquired(CacheTransaction cacheTransaction, AtomicInteger hasAttemptedToCommitUpdate) {
            this.cacheTransaction = cacheTransaction;
            this.hasAttemptedToCommitUpdate = hasAttemptedToCommitUpdate;
        }

        @Override
        public void onAcquired(Path acquired) {
            try {
                this.updateReference();
            }
            catch (IOException e) {
                gLogger.error((Object)("Got error when trying to update the cache reference: " + e.getMessage()));
            }
            finally {
                try {
                    CacheReference.this.fs.delete(acquired, false);
                }
                catch (IOException e) {
                    throw new CouldNotDeletePathException();
                }
            }
        }

        private void updateReference() throws IOException {
            this.hasAttemptedToCommitUpdate.incrementAndGet();
            Cache current = CacheReference.this.deref();
            this.cacheTransaction.prepare(current);
            this.cacheTransaction.commit();
        }
    }

    private class DeletingRefLockPathProvider
    implements SynchronizedExecuter.TempProvider<Path> {
        int modifyLimitInSecs = 60;

        private DeletingRefLockPathProvider() {
        }

        @Override
        public Path getTemp() {
            try {
                int limit = this.modifyLimitInSecs;
                if (this.isPathStale(CacheReference.this.newReferenceLock, limit)) {
                    CacheReference.this.fs.delete(CacheReference.this.newReferenceLock, false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return CacheReference.this.newReferenceLock;
        }

        private boolean isPathStale(Path p, int modifyLimitInSeconds) throws IOException {
            try {
                long modificationTime = CacheReference.this.fs.getFileStatus(p).getModificationTime();
                return IncrementFileCountWhenFileIsStale.wasLastModifiedLongerThanSecsAgo(modificationTime, modifyLimitInSeconds);
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    public static interface CacheTransaction {
        public void prepare(Cache var1) throws IOException;

        public void commit() throws IOException;
    }

    public static abstract class CacheUpdate {
        public abstract Map.Entry<PathType, String> getAddedPath();

        public Map<String, Long> getMergedPaths() {
            return Collections.emptyMap();
        }

        protected <K, V> Map<K, V> toMap(final K k, final V v) {
            return new HashMap<K, V>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put(k, v);
                }
            };
        }

        protected <K, V> Map.Entry<K, V> toEntry(K k, V v) {
            return this.toMap(k, v).entrySet().iterator().next();
        }

        public static enum PathType {
            MUTABLE,
            STABLE,
            DELETE;

        }
    }
}

