/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.integration;

import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.VixInputSplit;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;

public class SplitMetadata {
    private final Date latest;
    private final Date earliest;
    private final long splitSize;

    public SplitMetadata(Date latest, Date earliest, long splitSize) {
        this.latest = latest;
        this.earliest = earliest;
        this.splitSize = splitSize;
    }

    public Date getLatestTime() {
        return this.latest;
    }

    public Date getEarliestTime() {
        return this.earliest;
    }

    public long getSplitSize() {
        return this.splitSize;
    }

    public static SplitMetadata fromSplit(VixInputSplit split, Configuration conf) {
        if (SplunkMR.isCachePopulationSearch(conf)) {
            return new SplitMetadata(split.getLatestTimeAsDate(), split.getEarliestTimeAsDate(), split.getLength());
        }
        return null;
    }
}

