/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.packaging.CountingTempFileProvider;
import java.io.File;
import java.io.FileNotFoundException;

public class IncrementFileCountWhenFileIsStale
implements CountingTempFileProvider.IncrementCondition {
    static final int FILE_MODIFY_LIMIT_IN_SECONDS = 7;
    private int _fileModifyLimitInSeconds;

    public IncrementFileCountWhenFileIsStale(int fileModifyLimitInSeconds) {
        this._fileModifyLimitInSeconds = fileModifyLimitInSeconds;
    }

    public IncrementFileCountWhenFileIsStale() {
        this(7);
    }

    @Override
    public boolean shouldIncrementCount(File file) {
        try {
            return this.isFileStale(file);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    protected boolean isFileStale(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        return IncrementFileCountWhenFileIsStale.wasLastModifiedLongerThanSecsAgo(file.lastModified(), this._fileModifyLimitInSeconds);
    }

    public static boolean wasLastModifiedLongerThanSecsAgo(long lastModified, int modifyLimitInSeconds) {
        return IncrementFileCountWhenFileIsStale.toSec(lastModified) < IncrementFileCountWhenFileIsStale.toSec(System.currentTimeMillis()) - (long)modifyLimitInSeconds;
    }

    private static long toSec(long millis) {
        return millis / 1000L;
    }
}

