/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import com.splunk.util.HdfsUtil;
import com.splunk.util.LazySeq;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class PathGenerator
implements LazySeq.Generator<FileStatus> {
    private final FileSystem fs;
    private final LazySeq<FileStatus> parent;
    private final PathFilter filter;

    public PathGenerator(FileSystem fs, LazySeq<FileStatus> parent) {
        this(fs, parent, null);
    }

    public PathGenerator(FileSystem fs, LazySeq<FileStatus> parent, PathFilter filter) {
        this.fs = fs;
        this.parent = parent;
        this.filter = filter;
    }

    @Override
    public List<FileStatus> generate() throws IOException {
        List<FileStatus> ret = Collections.emptyList();
        while (ret.isEmpty() && this.parent.hasMore()) {
            ret = PathGenerator.listPath(this.fs, this.parent.getHead().getPath(), this.filter);
        }
        return ret;
    }

    public static List<FileStatus> listPath(FileSystem fs, Path path, PathFilter filter) throws IOException {
        FileStatus[] statuses = filter == null ? HdfsUtil.ls(fs, path) : HdfsUtil.ls(fs, path, filter);
        return Arrays.asList(statuses);
    }

    public static List<LazySeq<FileStatus>> chain(FileSystem fs, Path rootPath, int levels, Map<Integer, PathFilter> filters) {
        ArrayList<LazySeq<FileStatus>> chain = new ArrayList<LazySeq<FileStatus>>();
        chain.add(0, new RootPathSeq(fs, rootPath));
        for (int level = 1; level <= levels; ++level) {
            PathGenerator nextGenerator = new PathGenerator(fs, (LazySeq)chain.get(level - 1), filters.get(level));
            chain.add(level, new LazySeq<FileStatus>(nextGenerator));
        }
        return chain;
    }

    public static Iterable<FileStatus> recursiveLs(FileSystem fs, Path root) {
        return new BreadthFirstRecursiveLister(fs, root);
    }

    private static class BreadthFirstRecursiveLister
    extends LazySeq<FileStatus> {
        public BreadthFirstRecursiveLister(final FileSystem fs, final Path root) {
            super(new LazySeq.Generator<FileStatus>(){
                final LinkedList<Path> dirs = new LinkedList();
                volatile LazySeq.Generator<FileStatus> dirGenerator = BreadthFirstRecursiveLister.access$000(fs, root);

                @Override
                public synchronized List<FileStatus> generate() throws IOException {
                    List<FileStatus> generated = this.listDirectory(fs);
                    for (FileStatus f : generated) {
                        if (!f.isDir()) continue;
                        this.dirs.add(f.getPath());
                    }
                    return generated;
                }

                private List<FileStatus> listDirectory(FileSystem fs2) throws IOException {
                    List<FileStatus> files = this.dirGenerator.generate();
                    while (files.isEmpty() && !this.dirs.isEmpty()) {
                        this.dirGenerator = BreadthFirstRecursiveLister.generatorForPath(fs2, this.dirs.removeFirst());
                        files = this.dirGenerator.generate();
                    }
                    return files;
                }
            });
        }

        private static LazySeq.Generator<FileStatus> generatorForPath(final FileSystem fs, final Path path) {
            return new LazySeq.GenerateOnce<FileStatus>(){

                @Override
                protected List<FileStatus> generateOnce() throws IOException {
                    return Arrays.asList(HdfsUtil.ls(fs, path));
                }
            };
        }
    }

    public static class RootPathSeq
    extends LazySeq<FileStatus> {
        public RootPathSeq(final FileSystem fs, final Path path) {
            super(new LazySeq.GenerateOnce<FileStatus>(){

                @Override
                protected List<FileStatus> generateOnce() throws IOException {
                    if (fs.exists(path)) {
                        return Arrays.asList(fs.getFileStatus(path));
                    }
                    return Collections.emptyList();
                }
            });
        }
    }
}

