/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.ExecutorLogUrlHandler;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.History$;
import org.apache.spark.status.AppStatusListener;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.util.kvstore.KVStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!\u0002\u0007\u000e\u0001E9\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u0013)\u0002!\u0011!Q\u0001\n-\u001a\u0004\"\u0002\u001b\u0001\t\u0003)\u0004b\u0002\u001e\u0001\u0005\u0004%Ia\u000f\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f9\u0003!\u0019!C\u0005\u001f\"1a\u000b\u0001Q\u0001\nACQa\u0016\u0001\u0005BaCQa\u001c\u0001\u0005BADQa\u001d\u0001\u0005\nQDQ!\u001f\u0001\u0005\ni\u0014Q\u0003S5ti>\u0014\u00180\u00119q'R\fG/^:Ti>\u0014XM\u0003\u0002\u000f\u001f\u00059\u0001.[:u_JL(B\u0001\t\u0012\u0003\u0019!W\r\u001d7ps*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xmE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ!aG\t\u0002\rM$\u0018\r^;t\u0013\ti\"D\u0001\bBaB\u001cF/\u0019;vgN#xN]3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\n\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005\r\u0002#a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005\u001dBS\"A\t\n\u0005%\n\"!C*qCJ\\7i\u001c8g\u0003\u0015\u0019Ho\u001c:f!\ta\u0013'D\u0001.\u0015\tqs&A\u0004lmN$xN]3\u000b\u0005A\n\u0012\u0001B;uS2L!AM\u0017\u0003\u000f-36\u000b^8sK&\u0011!\u0006H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007YB\u0014\b\u0005\u00028\u00015\tQ\u0002C\u0003%\u0007\u0001\u0007a\u0005C\u0003+\u0007\u0001\u00071&A\u0007m_\u001e,&\u000f\u001c)biR,'O\\\u000b\u0002yA\u0019Q\b\u0011\"\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012aa\u00149uS>t\u0007CA\"K\u001d\t!\u0005\n\u0005\u0002F}5\taI\u0003\u0002HK\u00051AH]8pizJ!!\u0013 \u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013z\na\u0002\\8h+Jd\u0007+\u0019;uKJt\u0007%A\u0007m_\u001e,&\u000f\u001c%b]\u0012dWM]\u000b\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\u00111+E\u0001\tKb,7-\u001e;pe&\u0011QK\u0015\u0002\u0016\u000bb,7-\u001e;pe2{w-\u0016:m\u0011\u0006tG\r\\3s\u00039awnZ+sY\"\u000bg\u000e\u001a7fe\u0002\nA\"\u001a=fGV$xN\u001d'jgR$\"!\u00176\u0011\u0007i{&M\u0004\u0002\\;:\u0011Q\tX\u0005\u0002\u007f%\u0011aLP\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0017MA\u0002TKFT!A\u0018 \u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017A\u0001<2\u0015\t9'$A\u0002ba&L!!\u001b3\u0003\u001f\u0015CXmY;u_J\u001cV/\\7befDQa\u001b\u0005A\u00021\f!\"Y2uSZ,wJ\u001c7z!\tiT.\u0003\u0002o}\t9!i\\8mK\u0006t\u0017aD3yK\u000e,Ho\u001c:Tk6l\u0017M]=\u0015\u0005\t\f\b\"\u0002:\n\u0001\u0004\u0011\u0015AC3yK\u000e,Ho\u001c:JI\u0006q!/\u001a9mC\u000e,Gj\\4Ve2\u001cHc\u00012vo\")aO\u0003a\u0001E\u0006!Q\r_3d\u0011\u0015A(\u00021\u0001C\u0003))(\u000f\u001c)biR,'O\\\u0001\u0014e\u0016\u0004H.Y2f\u000bb,7-\u001e;pe2{wm\u001d\u000b\u0004Enl\b\"\u0002?\f\u0001\u0004\u0011\u0017AB:pkJ\u001cW\rC\u0003\u007f\u0017\u0001\u0007q0A\boK^,\u00050Z2vi>\u0014Hj\\4t!\u0015\u0019\u0015\u0011\u0001\"C\u0013\r\t\u0019\u0001\u0014\u0002\u0004\u001b\u0006\u0004\b")
public class HistoryAppStatusStore
extends AppStatusStore
implements Logging {
    private final Option<String> logUrlPattern;
    private final ExecutorLogUrlHandler logUrlHandler;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<String> logUrlPattern() {
        return this.logUrlPattern;
    }

    private ExecutorLogUrlHandler logUrlHandler() {
        return this.logUrlHandler;
    }

    @Override
    public Seq<ExecutorSummary> executorList(boolean activeOnly) {
        Seq seq;
        Seq execList = super.executorList(activeOnly);
        Option<String> option = this.logUrlPattern();
        if (option instanceof Some) {
            Some some = (Some)option;
            String pattern = (String)some.value();
            seq = (Seq)execList.map((Function1 & Serializable & scala.Serializable)x$1 -> this.replaceLogUrls((ExecutorSummary)x$1, pattern), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq = execList;
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    @Override
    public ExecutorSummary executorSummary(String executorId) {
        ExecutorSummary executorSummary;
        ExecutorSummary execSummary = super.executorSummary(executorId);
        Option<String> option = this.logUrlPattern();
        if (option instanceof Some) {
            Some some = (Some)option;
            String pattern = (String)some.value();
            executorSummary = this.replaceLogUrls(execSummary, pattern);
        } else if (None$.MODULE$.equals(option)) {
            executorSummary = execSummary;
        } else {
            throw new MatchError(option);
        }
        return executorSummary;
    }

    private ExecutorSummary replaceLogUrls(ExecutorSummary exec, String urlPattern) {
        Map<String, String> newLogUrlMap = this.logUrlHandler().applyPattern(exec.executorLogs(), exec.attributes());
        return this.replaceExecutorLogs(exec, newLogUrlMap);
    }

    private ExecutorSummary replaceExecutorLogs(ExecutorSummary source, Map<String, String> newExecutorLogs) {
        return new ExecutorSummary(source.id(), source.hostPort(), source.isActive(), source.rddBlocks(), source.memoryUsed(), source.diskUsed(), source.totalCores(), source.maxTasks(), source.activeTasks(), source.failedTasks(), source.completedTasks(), source.totalTasks(), source.totalDuration(), source.totalGCTime(), source.totalInputBytes(), source.totalShuffleRead(), source.totalShuffleWrite(), source.isBlacklisted(), source.maxMemory(), source.addTime(), source.removeTime(), source.removeReason(), newExecutorLogs, source.memoryMetrics(), source.blacklistedInStages(), source.peakMemoryMetrics(), source.attributes(), source.resources());
    }

    public HistoryAppStatusStore(SparkConf conf, KVStore store) {
        super(store, (Option<AppStatusListener>)None$.MODULE$);
        Logging.$init$(this);
        ApplicationInfo appInfo = super.applicationInfo();
        boolean applicationCompleted = appInfo.attempts().nonEmpty() && ((ApplicationAttemptInfo)appInfo.attempts().head()).completed();
        this.logUrlPattern = applicationCompleted || BoxesRunTime.unboxToBoolean((Object)conf.get(History$.MODULE$.APPLY_CUSTOM_EXECUTOR_LOG_URL_TO_INCOMPLETE_APP())) ? (Option)conf.get(History$.MODULE$.CUSTOM_EXECUTOR_LOG_URL()) : None$.MODULE$;
        this.logUrlHandler = new ExecutorLogUrlHandler(this.logUrlPattern());
    }
}

