/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00154Q\u0001D\u0007\u0001\u001fUA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006KA\u000b\u0005\ta\u0001\u0011\t\u0011)Q\u0005c!Aq\u0007\u0001B\u0001B\u0003&\u0001\bC\u0003<\u0001\u0011\u0005A\bC\u0003<\u0001\u0011E\u0011\tC\u0003<\u0001\u0011\u0005!\tC\u0003J\u0001\u0011\u0005#\nC\u0003L\u0001\u0011\u0005C\nC\u0003S\u0001\u0011\u00053\u000bC\u0003U\u0001\u0011\u0005S\u000bC\u0003_\u0001\u0011\u0005sLA\nD_6\u0004(/Z:tK\u0012l\u0015\r]*uCR,8O\u0003\u0002\u000f\u001f\u0005I1o\u00195fIVdWM\u001d\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sON!\u0001A\u0006\u000f!!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDH\u0007\u0002\u001b%\u0011q$\u0004\u0002\n\u001b\u0006\u00048\u000b^1ukN\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005%|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012a\"\u0012=uKJt\u0017\r\\5{C\ndW-A\u0002m_\u000e\u001c\u0001\u0001\u0005\u0002,]5\tAF\u0003\u0002.\u001f\u000591\u000f^8sC\u001e,\u0017BA\u0018-\u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\fqbY8naJ,7o]3e'&TXm\u001d\t\u0004/I\"\u0014BA\u001a\u0019\u0005\u0015\t%O]1z!\t9R'\u0003\u000271\t!!)\u001f;f\u0003)yV.\u00199UCN\\\u0017\n\u001a\t\u0003/eJ!A\u000f\r\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\turt\b\u0011\t\u0003;\u0001AQ\u0001\u000b\u0003A\u0002)BQ\u0001\r\u0003A\u0002EBQa\u000e\u0003A\u0002a\"\u0012!\u0010\u000b\u0005{\r#u\tC\u0003)\r\u0001\u0007!\u0006C\u0003F\r\u0001\u0007a)A\tv]\u000e|W\u000e\u001d:fgN,GmU5{KN\u00042a\u0006\u001a9\u0011\u0015Ae\u00011\u00019\u0003%i\u0017\r\u001d+bg.LE-\u0001\u0005m_\u000e\fG/[8o+\u0005Q\u0013aD4fiNK'0\u001a$pe\ncwnY6\u0015\u0005aj\u0005\"\u0002(\t\u0001\u0004y\u0015\u0001\u0003:fIV\u001cW-\u00133\u0011\u0005]\u0001\u0016BA)\u0019\u0005\rIe\u000e^\u0001\u0006[\u0006\u0004\u0018\nZ\u000b\u0002q\u0005iqO]5uK\u0016CH/\u001a:oC2$\"AV-\u0011\u0005]9\u0016B\u0001-\u0019\u0005\u0011)f.\u001b;\t\u000biS\u0001\u0019A.\u0002\u0007=,H\u000f\u0005\u0002\"9&\u0011QL\t\u0002\r\u001f\nTWm\u0019;PkR\u0004X\u000f^\u0001\re\u0016\fG-\u0012=uKJt\u0017\r\u001c\u000b\u0003-\u0002DQ!Y\u0006A\u0002\t\f!!\u001b8\u0011\u0005\u0005\u001a\u0017B\u00013#\u0005-y%M[3di&s\u0007/\u001e;")
public class CompressedMapStatus
implements MapStatus,
Externalizable {
    private BlockManagerId loc;
    private byte[] compressedSizes;
    private long _mapTaskId;

    @Override
    public BlockManagerId location() {
        return this.loc;
    }

    @Override
    public long getSizeForBlock(int reduceId) {
        return MapStatus$.MODULE$.decompressSize(this.compressedSizes[reduceId]);
    }

    @Override
    public long mapId() {
        return this._mapTaskId;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            $this.loc.writeExternal(out);
            out.writeInt($this.compressedSizes.length);
            out.write($this.compressedSizes);
            out.writeLong($this._mapTaskId);
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            $this.loc = BlockManagerId$.MODULE$.apply(in);
            int len = in.readInt();
            $this.compressedSizes = new byte[len];
            in.readFully($this.compressedSizes);
            $this._mapTaskId = in.readLong();
        });
    }

    public CompressedMapStatus(BlockManagerId loc, byte[] compressedSizes, long _mapTaskId) {
        this.loc = loc;
        this.compressedSizes = compressedSizes;
        this._mapTaskId = _mapTaskId;
    }

    public CompressedMapStatus() {
        this((BlockManagerId)null, (byte[])null, -1L);
    }

    public CompressedMapStatus(BlockManagerId loc, long[] uncompressedSizes, long mapTaskId) {
        this(loc, (byte[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(uncompressedSizes)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(long size) {
                return MapStatus$.MODULE$.compressSize(size);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())), mapTaskId);
    }
}

