/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExecutorFailuresInTaskSet;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklistedForStage;
import org.apache.spark.scheduler.SparkListenerNodeBlacklistedForStage;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!B\u0014)\u0001!\u0002\u0004\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011B \t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0001C\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000f\"AA\n\u0001BC\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003O\u0011!\u0011\u0006A!b\u0001\n\u0003i\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\u0006;\u0002!\tA\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0003N\u0011\u00191\u0007\u0001)A\u0005\u001d\"9q\r\u0001b\u0001\n\u0013i\u0005B\u00025\u0001A\u0003%a\nC\u0004j\u0001\t\u0007I\u0011B'\t\r)\u0004\u0001\u0015!\u0003O\u0011\u001dY\u0007A1A\u0005\n5Ca\u0001\u001c\u0001!\u0002\u0013q\u0005bB7\u0001\u0005\u0004%\tA\u001c\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003p\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\t\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u0010\u0011%\t)\u0003\u0001b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\n\u0011%\tY\u0003\u0001b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\n\u0011%\ty\u0003\u0001a\u0001\n\u0013\t\t\u0004C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026!9\u0011\u0011\t\u0001!B\u00139\bbBA\"\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u0011\u00055\u0004\u0001\"\u0001)\u0003_\u0012\u0001\u0003V1tWN+GO\u00117bG.d\u0017n\u001d;\u000b\u0005%R\u0013!C:dQ\u0016$W\u000f\\3s\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7c\u0001\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0016\u0002\u0011%tG/\u001a:oC2L!\u0001P\u001d\u0003\u000f1{wmZ5oO\u0006YA.[:uK:,'OQ;t\u0007\u0001)\u0012\u0001\u0011\t\u0003\u0003\nk\u0011\u0001K\u0005\u0003\u0007\"\u0012q\u0002T5wK2K7\u000f^3oKJ\u0014Uo]\u0001\rY&\u001cH/\u001a8fe\n+8\u000fI\u0001\u0005G>tg-F\u0001H!\tA\u0015*D\u0001+\u0013\tQ%FA\u0005Ta\u0006\u00148nQ8oM\u0006)1m\u001c8gA\u000591\u000f^1hK&#W#\u0001(\u0011\u0005Iz\u0015B\u0001)4\u0005\rIe\u000e^\u0001\tgR\fw-Z%eA\u0005q1\u000f^1hK\u0006#H/Z7qi&#\u0017aD:uC\u001e,\u0017\t\u001e;f[B$\u0018\n\u001a\u0011\u0002\u000b\rdwnY6\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u0016\u0002\tU$\u0018\u000e\\\u0005\u00037b\u0013Qa\u00117pG.\faa\u00197pG.\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004`A\u0006\u00147\r\u001a\t\u0003\u0003\u0002AQ!P\u0006A\u0002\u0001CQ!R\u0006A\u0002\u001dCQ\u0001T\u0006A\u00029CQAU\u0006A\u00029CQ\u0001V\u0006A\u0002Y\u000ba$T!Y?R\u000b5kS0B)R+U\n\u0015+T?B+%kX#Y\u000b\u000e+Fk\u0014*\u0002?5\u000b\u0005l\u0018+B'.{\u0016\t\u0016+F\u001bB#6k\u0018)F%~+\u0005,R\"V)>\u0013\u0006%\u0001\u000eN\u0003b{F+Q*L?\u0006#F+R'Q)N{\u0006+\u0012*`\u001d>#U)A\u000eN\u0003b{F+Q*L?\u0006#F+R'Q)N{\u0006+\u0012*`\u001d>#U\tI\u0001\u001c\u001b\u0006CvLR!J\u0019V\u0013ViU0Q\u000bJ{V\tW#D?N#\u0016iR#\u000295\u000b\u0005l\u0018$B\u00132+&+R*`!\u0016\u0013v,\u0012-F\u0007~\u001bF+Q$FA\u0005qR*\u0011-`\r\u0006KE*\u0012#`\u000bb+5i\u0018)F%~su\nR#`'R\u000bu)R\u0001 \u001b\u0006CvLR!J\u0019\u0016#u,\u0012-F\u0007~\u0003VIU0O\u001f\u0012+ul\u0015+B\u000f\u0016\u0003\u0013AD3yK\u000e$vNR1jYV\u0014Xm]\u000b\u0002_B)\u0001/^<\u0002\u00065\t\u0011O\u0003\u0002sg\u00069Q.\u001e;bE2,'B\u0001;4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mF\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002y\u007f:\u0011\u00110 \t\u0003uNj\u0011a\u001f\u0006\u0003yz\na\u0001\u0010:p_Rt\u0014B\u0001@4\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011ap\r\t\u0004\u0003\u0006\u001d\u0011bAA\u0005Q\tIR\t_3dkR|'OR1jYV\u0014Xm]%o)\u0006\u001c8nU3u\u0003=)\u00070Z2U_\u001a\u000b\u0017\u000e\\;sKN\u0004\u0013a\u00068pI\u0016$v.\u0012=fGN<\u0016\u000e\u001e5GC&dWO]3t+\t\t\t\u0002E\u0003qk^\f\u0019\u0002\u0005\u0003q\u0003+9\u0018bAA\fc\n9\u0001*Y:i'\u0016$\u0018\u0001\u00078pI\u0016$v.\u0012=fGN<\u0016\u000e\u001e5GC&dWO]3tA\u0005abn\u001c3f)>\u0014E.Y2lY&\u001cH/\u001a3UCN\\\u0017J\u001c3fq\u0016\u001cXCAA\u0010!\u0015\u0001Xo^A\u0011!\u0011\u0001\u0018Q\u0003(\u0002;9|G-\u001a+p\u00052\f7m\u001b7jgR,G\rV1tW&sG-\u001a=fg\u0002\n\u0001C\u00197bG.d\u0017n\u001d;fI\u0016CXmY:\u0016\u0005\u0005M\u0011!\u00052mC\u000e\\G.[:uK\u0012,\u00050Z2tA\u0005\u0001\"\r\\1dW2L7\u000f^3e\u001d>$Wm]\u0001\u0012E2\f7m\u001b7jgR,GMT8eKN\u0004\u0013a\u00057bi\u0016\u001cHOR1jYV\u0014XMU3bg>tW#A<\u0002/1\fG/Z:u\r\u0006LG.\u001e:f%\u0016\f7o\u001c8`I\u0015\fH\u0003BA\u001c\u0003{\u00012AMA\u001d\u0013\r\tYd\r\u0002\u0005+:LG\u000f\u0003\u0005\u0002@}\t\t\u00111\u0001x\u0003\rAH%M\u0001\u0015Y\u0006$Xm\u001d;GC&dWO]3SK\u0006\u001cxN\u001c\u0011\u0002-\u001d,G\u000fT1uKN$h)Y5mkJ,'+Z1t_:\fA$[:Fq\u0016\u001cW\u000f^8s\u00052\f7m\u001b7jgR,GMR8s)\u0006\u001c8\u000e\u0006\u0004\u0002J\u0005=\u00131\u000b\t\u0004e\u0005-\u0013bAA'g\t9!i\\8mK\u0006t\u0007BBA)E\u0001\u0007q/\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012Da!!\u0016#\u0001\u0004q\u0015!B5oI\u0016D\u0018\u0001G5t\u001d>$WM\u00117bG.d\u0017n\u001d;fI\u001a{'\u000fV1tWR1\u0011\u0011JA.\u0003?Ba!!\u0018$\u0001\u00049\u0018\u0001\u00028pI\u0016Da!!\u0016$\u0001\u0004q\u0015aH5t\u000bb,7-\u001e;pe\nc\u0017mY6mSN$X\r\u001a$peR\u000b7o[*fiR!\u0011\u0011JA3\u0011\u0019\t\t\u0006\na\u0001o\u0006Y\u0012n\u001d(pI\u0016\u0014E.Y2lY&\u001cH/\u001a3G_J$\u0016m]6TKR$B!!\u0013\u0002l!1\u0011QL\u0013A\u0002]\fA$\u001e9eCR,'\t\\1dW2L7\u000f\u001e$pe\u001a\u000b\u0017\u000e\\3e)\u0006\u001c8\u000e\u0006\u0006\u00028\u0005E\u0014QOA=\u0003wBa!a\u001d'\u0001\u00049\u0018\u0001\u00025pgRDa!a\u001e'\u0001\u00049\u0018\u0001B3yK\u000eDa!!\u0016'\u0001\u0004q\u0005BBA?M\u0001\u0007q/A\u0007gC&dWO]3SK\u0006\u001cxN\u001c")
public class TaskSetBlacklist
implements Logging {
    private final LiveListenerBus listenerBus;
    private final SparkConf conf;
    private final int stageId;
    private final int stageAttemptId;
    private final Clock clock;
    private final int MAX_TASK_ATTEMPTS_PER_EXECUTOR;
    private final int MAX_TASK_ATTEMPTS_PER_NODE;
    private final int MAX_FAILURES_PER_EXEC_STAGE;
    private final int MAX_FAILED_EXEC_PER_NODE_STAGE;
    private final HashMap<String, ExecutorFailuresInTaskSet> execToFailures;
    private final HashMap<String, HashSet<String>> nodeToExecsWithFailures;
    private final HashMap<String, HashSet<Object>> nodeToBlacklistedTaskIndexes;
    private final HashSet<String> blacklistedExecs;
    private final HashSet<String> blacklistedNodes;
    private String latestFailureReason;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public int stageId() {
        return this.stageId;
    }

    public int stageAttemptId() {
        return this.stageAttemptId;
    }

    public Clock clock() {
        return this.clock;
    }

    private int MAX_TASK_ATTEMPTS_PER_EXECUTOR() {
        return this.MAX_TASK_ATTEMPTS_PER_EXECUTOR;
    }

    private int MAX_TASK_ATTEMPTS_PER_NODE() {
        return this.MAX_TASK_ATTEMPTS_PER_NODE;
    }

    private int MAX_FAILURES_PER_EXEC_STAGE() {
        return this.MAX_FAILURES_PER_EXEC_STAGE;
    }

    private int MAX_FAILED_EXEC_PER_NODE_STAGE() {
        return this.MAX_FAILED_EXEC_PER_NODE_STAGE;
    }

    public HashMap<String, ExecutorFailuresInTaskSet> execToFailures() {
        return this.execToFailures;
    }

    private HashMap<String, HashSet<String>> nodeToExecsWithFailures() {
        return this.nodeToExecsWithFailures;
    }

    private HashMap<String, HashSet<Object>> nodeToBlacklistedTaskIndexes() {
        return this.nodeToBlacklistedTaskIndexes;
    }

    private HashSet<String> blacklistedExecs() {
        return this.blacklistedExecs;
    }

    private HashSet<String> blacklistedNodes() {
        return this.blacklistedNodes;
    }

    private String latestFailureReason() {
        return this.latestFailureReason;
    }

    private void latestFailureReason_$eq(String x$1) {
        this.latestFailureReason = x$1;
    }

    public String getLatestFailureReason() {
        return this.latestFailureReason();
    }

    public boolean isExecutorBlacklistedForTask(String executorId, int index) {
        return this.execToFailures().get((Object)executorId).exists((Function1 & Serializable & scala.Serializable)execFailures -> BoxesRunTime.boxToBoolean((boolean)TaskSetBlacklist.$anonfun$isExecutorBlacklistedForTask$1(this, index, execFailures)));
    }

    public boolean isNodeBlacklistedForTask(String node, int index) {
        return this.nodeToBlacklistedTaskIndexes().get((Object)node).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains((Object)BoxesRunTime.boxToInteger((int)index))));
    }

    public boolean isExecutorBlacklistedForTaskSet(String executorId) {
        return this.blacklistedExecs().contains((Object)executorId);
    }

    public boolean isNodeBlacklistedForTaskSet(String node) {
        return this.blacklistedNodes().contains((Object)node);
    }

    public void updateBlacklistForFailedTask(String host, String exec2, int index, String failureReason) {
        block1: {
            this.latestFailureReason_$eq(failureReason);
            ExecutorFailuresInTaskSet execFailures = (ExecutorFailuresInTaskSet)this.execToFailures().getOrElseUpdate((Object)exec2, (Function0 & Serializable & scala.Serializable)() -> new ExecutorFailuresInTaskSet(host));
            execFailures.updateWithFailure(index, this.clock().getTimeMillis());
            HashSet execsWithFailuresOnNode = (HashSet)this.nodeToExecsWithFailures().getOrElseUpdate((Object)host, (Function0 & Serializable & scala.Serializable)() -> new HashSet());
            execsWithFailuresOnNode.$plus$eq((Object)exec2);
            int failuresOnHost = BoxesRunTime.unboxToInt((Object)execsWithFailuresOnNode.toIterator().flatMap((Function1 & Serializable & scala.Serializable)exec -> Option$.MODULE$.option2Iterable(this.execToFailures().get(exec).map((Function1 & Serializable & scala.Serializable)failures -> BoxesRunTime.boxToInteger((int)failures.getNumTaskFailures(index))))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Object object = failuresOnHost >= this.MAX_TASK_ATTEMPTS_PER_NODE() ? ((HashSet)this.nodeToBlacklistedTaskIndexes().getOrElseUpdate((Object)host, (Function0 & Serializable & scala.Serializable)() -> new HashSet())).$plus$eq((Object)BoxesRunTime.boxToInteger((int)index)) : BoxedUnit.UNIT;
            int numFailures = execFailures.numUniqueTasksWithFailures();
            if (numFailures < this.MAX_FAILURES_PER_EXEC_STAGE() || !this.blacklistedExecs().add((Object)exec2)) break block1;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Blacklisting executor ").append(exec2).append(" for stage ").append(this.stageId()).toString());
            HashSet blacklistedExecutorsOnNode = (HashSet)execsWithFailuresOnNode.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TaskSetBlacklist.$anonfun$updateBlacklistForFailedTask$7(this, x$2)));
            long now = this.clock().getTimeMillis();
            this.listenerBus().post(new SparkListenerExecutorBlacklistedForStage(now, exec2, numFailures, this.stageId(), this.stageAttemptId()));
            int numFailExec = blacklistedExecutorsOnNode.size();
            if (numFailExec >= this.MAX_FAILED_EXEC_PER_NODE_STAGE() && this.blacklistedNodes().add((Object)host)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Blacklisting ").append(host).append(" for stage ").append(this.stageId()).toString());
                this.listenerBus().post(new SparkListenerNodeBlacklistedForStage(now, host, numFailExec, this.stageId(), this.stageAttemptId()));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExecutorBlacklistedForTask$1(TaskSetBlacklist $this, int index$1, ExecutorFailuresInTaskSet execFailures) {
        return execFailures.getNumTaskFailures(index$1) >= $this.MAX_TASK_ATTEMPTS_PER_EXECUTOR();
    }

    public static final /* synthetic */ boolean $anonfun$updateBlacklistForFailedTask$7(TaskSetBlacklist $this, String x$2) {
        return $this.blacklistedExecs().contains((Object)x$2);
    }

    public TaskSetBlacklist(LiveListenerBus listenerBus, SparkConf conf, int stageId, int stageAttemptId, Clock clock) {
        this.listenerBus = listenerBus;
        this.conf = conf;
        this.stageId = stageId;
        this.stageAttemptId = stageAttemptId;
        this.clock = clock;
        Logging.$init$(this);
        this.MAX_TASK_ATTEMPTS_PER_EXECUTOR = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_EXECUTOR()));
        this.MAX_TASK_ATTEMPTS_PER_NODE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE()));
        this.MAX_FAILURES_PER_EXEC_STAGE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_FAILURES_PER_EXEC_STAGE()));
        this.MAX_FAILED_EXEC_PER_NODE_STAGE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_FAILED_EXEC_PER_NODE_STAGE()));
        this.execToFailures = new HashMap();
        this.nodeToExecsWithFailures = new HashMap();
        this.nodeToBlacklistedTaskIndexes = new HashMap();
        this.blacklistedExecs = new HashSet();
        this.blacklistedNodes = new HashSet();
        this.latestFailureReason = null;
    }
}

