/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B%K\u0001MC\u0001B\u0019\u0001\u0003\u0002\u0004%Ia\u0019\u0005\tU\u0002\u0011\t\u0019!C\u0005W\"A\u0011\u000f\u0001B\u0001B\u0003&A\r\u0003\u0005s\u0001\t\u0005\r\u0011\"\u0003d\u0011!\u0019\bA!a\u0001\n\u0013!\b\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0015\u00023\t\u0011]\u0004!\u00111A\u0005\n\rD\u0001\u0002\u001f\u0001\u0003\u0002\u0004%I!\u001f\u0005\tw\u0002\u0011\t\u0011)Q\u0005I\"AA\u0010\u0001BA\u0002\u0013%1\r\u0003\u0005~\u0001\t\u0005\r\u0011\"\u0003\u007f\u0011%\t\t\u0001\u0001B\u0001B\u0003&A\r\u0003\u0006\u0002\u0004\u0001\u0011\t\u0019!C\u0005\u0003\u000bA!\"!\u0004\u0001\u0005\u0003\u0007I\u0011BA\b\u0011)\t\u0019\u0002\u0001B\u0001B\u0003&\u0011q\u0001\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\t)\u0002\u0001C\u0005\u0003OAq!!\u0006\u0001\t\u0003\t\t\u0004\u0003\u0004\u00024\u0001!\ta\u0019\u0005\u0007\u0003k\u0001A\u0011A2\t\r\u0005]\u0002\u0001\"\u0001d\u0011\u0019\tI\u0004\u0001C\u0001G\"9\u0011q\u0006\u0001\u0005\u0002\u0005\u0015\u0001\u0002CA\u001e\u0001\u0011\u0005A*!\u0010\t\u000f\u0005-\u0003\u0001\"\u0011\u00022!9\u0011Q\n\u0001\u0005B\u0005=\u0003BBA.\u0001\u0011\u00051\rC\u0004\u0002^\u0001!\t!!\u0002\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u001f\u0003A\u0011IAI\u0011\u001d\tI\u000b\u0001C!\u0003WCq!!,\u0001\t\u0003\tykB\u0004\u0002@*C\t!!1\u0007\r%S\u0005\u0012AAb\u0011\u001d\t)\u0002\nC\u0001\u0003#D\u0011\"a5%\u0005\u0004%\t!!6\t\u0011\u0005]G\u0005)A\u0005\u00033A\u0011\"!7%\u0005\u0004%\t!!6\t\u0011\u0005mG\u0005)A\u0005\u00033A\u0011\"!8%\u0005\u0004%\t!!6\t\u0011\u0005}G\u0005)A\u0005\u00033A\u0011\"!9%\u0005\u0004%\t!!6\t\u0011\u0005\rH\u0005)A\u0005\u00033A\u0011\"!:%\u0005\u0004%\t!!6\t\u0011\u0005\u001dH\u0005)A\u0005\u00033A\u0011\"!;%\u0005\u0004%\t!!6\t\u0011\u0005-H\u0005)A\u0005\u00033A\u0011\"!<%\u0005\u0004%\t!!6\t\u0011\u0005=H\u0005)A\u0005\u00033A\u0011\"!=%\u0005\u0004%\t!!6\t\u0011\u0005MH\u0005)A\u0005\u00033A\u0011\"!>%\u0005\u0004%\t!!6\t\u0011\u0005]H\u0005)A\u0005\u00033A\u0011\"!?%\u0005\u0004%\t!!6\t\u0011\u0005mH\u0005)A\u0005\u00033A\u0011\"!@%\u0005\u0004%\t!!6\t\u0011\u0005}H\u0005)A\u0005\u00033A\u0011B!\u0001%\u0005\u0004%\t!!6\t\u0011\t\rA\u0005)A\u0005\u00033AqA!\u0002%\t\u0003\u00119\u0001C\u0004\u0003\u0010\u0011\"\tA!\u0005\t\u000f\t=A\u0005\"\u0001\u0003 !I!1\u0006\u0013\u0012\u0002\u0013\u0005!Q\u0006\u0005\b\u0005\u001f!C\u0011\u0001B!\u0011\u001d\u0011y\u0001\nC\u0001\u0005\u0013B!Ba\u0014%\u0005\u0004%\t\u0001\u0014B)\u0011!\u0011\u0019\u0007\nQ\u0001\n\tM\u0003\u0002\u0003B3I\u0011\u0005AJa\u001a\t\u0013\t5D%%A\u0005\n\t5\u0002\"CA>I\u0005\u0005I\u0011BA?\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0015\tYE*A\u0004ti>\u0014\u0018mZ3\u000b\u00055s\u0015!B:qCJ\\'BA(Q\u0003\u0019\t\u0007/Y2iK*\t\u0011+A\u0002pe\u001e\u001c\u0001aE\u0002\u0001)r\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\t1\fgn\u001a\u0006\u00023\u0006!!.\u0019<b\u0013\tYfK\u0001\u0004PE*,7\r\u001e\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?b\u000b!![8\n\u0005\u0005t&AD#yi\u0016\u0014h.\u00197ju\u0006\u0014G.Z\u0001\t?V\u001cX\rR5tWV\tA\r\u0005\u0002fQ6\taMC\u0001h\u0003\u0015\u00198-\u00197b\u0013\tIgMA\u0004C_>dW-\u00198\u0002\u0019}+8/\u001a#jg.|F%Z9\u0015\u00051|\u0007CA3n\u0013\tqgM\u0001\u0003V]&$\bb\u00029\u0003\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\n\u0014!C0vg\u0016$\u0015n]6!\u0003)yVo]3NK6|'/_\u0001\u000f?V\u001cX-T3n_JLx\fJ3r)\taW\u000fC\u0004q\u000b\u0005\u0005\t\u0019\u00013\u0002\u0017}+8/Z'f[>\u0014\u0018\u0010I\u0001\f?V\u001cXm\u00144g\u0011\u0016\f\u0007/A\b`kN,wJ\u001a4IK\u0006\u0004x\fJ3r)\ta'\u0010C\u0004q\u0011\u0005\u0005\t\u0019\u00013\u0002\u0019}+8/Z(gM\"+\u0017\r\u001d\u0011\u0002\u001b}#Wm]3sS\u0006d\u0017N_3e\u0003EyF-Z:fe&\fG.\u001b>fI~#S-\u001d\u000b\u0003Y~Dq\u0001]\u0006\u0002\u0002\u0003\u0007A-\u0001\b`I\u0016\u001cXM]5bY&TX\r\u001a\u0011\u0002\u0019}\u0013X\r\u001d7jG\u0006$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0001cA3\u0002\n%\u0019\u00111\u00024\u0003\u0007%sG/\u0001\t`e\u0016\u0004H.[2bi&|gn\u0018\u0013fcR\u0019A.!\u0005\t\u0011At\u0011\u0011!a\u0001\u0003\u000f\tQb\u0018:fa2L7-\u0019;j_:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0007\u0002\u001a\u0005u\u0011qDA\u0011\u0003G\t)\u0003E\u0002\u0002\u001c\u0001i\u0011A\u0013\u0005\u0006EB\u0001\r\u0001\u001a\u0005\u0006eB\u0001\r\u0001\u001a\u0005\u0006oB\u0001\r\u0001\u001a\u0005\u0006yB\u0001\r\u0001\u001a\u0005\n\u0003\u0007\u0001\u0002\u0013!a\u0001\u0003\u000f!b!!\u0007\u0002*\u00055\u0002bBA\u0016#\u0001\u0007\u0011qA\u0001\u0006M2\fwm\u001d\u0005\b\u0003_\t\u0002\u0019AA\u0004\u0003-\u0011X\r\u001d7jG\u0006$\u0018n\u001c8\u0015\u0005\u0005e\u0011aB;tK\u0012K7o[\u0001\nkN,W*Z7pef\f!\"^:f\u001f\u001a4\u0007*Z1q\u00031!Wm]3sS\u0006d\u0017N_3e\u0003)iW-\\8ss6{G-Z\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bb\u0015AB7f[>\u0014\u00180\u0003\u0003\u0002J\u0005\r#AC'f[>\u0014\u00180T8eK\u0006)1\r\\8oK\u00061Q-];bYN$2\u0001ZA)\u0011\u001d\t\u0019F\u0007a\u0001\u0003+\nQa\u001c;iKJ\u00042!ZA,\u0013\r\tIF\u001a\u0002\u0004\u0003:L\u0018aB5t-\u0006d\u0017\u000eZ\u0001\u0006i>Le\u000e^\u0001\u000eoJLG/Z#yi\u0016\u0014h.\u00197\u0015\u00071\f\u0019\u0007C\u0004\u0002fu\u0001\r!a\u001a\u0002\u0007=,H\u000fE\u0002^\u0003SJ1!a\u001b_\u00051y%M[3di>+H\u000f];u\u00031\u0011X-\u00193FqR,'O\\1m)\ra\u0017\u0011\u000f\u0005\b\u0003gr\u0002\u0019AA;\u0003\tIg\u000eE\u0002^\u0003oJ1!!\u001f_\u0005-y%M[3di&s\u0007/\u001e;\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002)\"*q$!!\u0002\u000eB)Q-a!\u0002\b&\u0019\u0011Q\u00114\u0003\rQD'o\\<t!\ri\u0016\u0011R\u0005\u0004\u0003\u0017s&aC%P\u000bb\u001cW\r\u001d;j_:\u001c#!a\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a%\u0011\t\u0005U\u00151\u0015\b\u0005\u0003/\u000by\nE\u0002\u0002\u001a\u001al!!a'\u000b\u0007\u0005u%+\u0001\u0004=e>|GOP\u0005\u0004\u0003C3\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002&\u0006\u001d&AB*ue&twMC\u0002\u0002\"\u001a\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u000f\t1\u0002Z3tGJL\u0007\u000f^5p]V\u0011\u00111\u0013\u0015\u0004\u0001\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005eF*\u0001\u0006b]:|G/\u0019;j_:LA!!0\u00028\naA)\u001a<fY>\u0004XM]!qS\u0006a1\u000b^8sC\u001e,G*\u001a<fYB\u0019\u00111\u0004\u0013\u0014\u000b\u0011\n)-a3\u0011\u0007\u0015\f9-C\u0002\u0002J\u001a\u0014a!\u00118z%\u00164\u0007cA3\u0002N&\u0019\u0011q\u001a4\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005\u0005\u0017\u0001\u0002(P\u001d\u0016+\"!!\u0007\u0002\u000b9{e*\u0012\u0011\u0002\u0013\u0011K5kS0P\u001d2K\u0016A\u0003#J'.{vJ\u0014'ZA\u0005YA)S*L?>sE*W03\u00031!\u0015jU&`\u001f:c\u0015l\u0018\u001a!\u0003-iU)T(S3~{e\nT-\u0002\u00195+Uj\u0014*Z?>sE*\u0017\u0011\u0002\u001b5+Uj\u0014*Z?>sE*W03\u00039iU)T(S3~{e\nT-`e\u0001\nq\"T#N\u001fJKvl\u0014(M3~\u001bVIU\u0001\u0011\u001b\u0016kuJU-`\u001f:c\u0015lX*F%\u0002\n\u0011#T#N\u001fJKvl\u0014(M3~\u001bVIU03\u0003IiU)T(S3~{e\nT-`'\u0016\u0013vL\r\u0011\u0002\u001f5+Uj\u0014*Z?\u0006sEi\u0018#J'.\u000b\u0001#T#N\u001fJKv,\u0011(E?\u0012K5k\u0013\u0011\u0002#5+Uj\u0014*Z?\u0006sEi\u0018#J'.{&'\u0001\nN\u000b6{%+W0B\u001d\u0012{F)S*L?J\u0002\u0013aE'F\u001b>\u0013\u0016lX!O\t~#\u0015jU&`'\u0016\u0013\u0016\u0001F'F\u001b>\u0013\u0016lX!O\t~#\u0015jU&`'\u0016\u0013\u0006%A\u000bN\u000b6{%+W0B\u001d\u0012{F)S*L?N+%k\u0018\u001a\u0002-5+Uj\u0014*Z?\u0006sEi\u0018#J'.{6+\u0012*`e\u0001\n\u0001b\u0014$G?\"+\u0015\tU\u0001\n\u001f\u001a3u\fS#B!\u0002\n!B\u001a:p[N#(/\u001b8h)\u0011\tIB!\u0003\t\u000f\t-a\b1\u0001\u0002\u0014\u0006\t1\u000fK\u0002?\u0003g\u000bQ!\u00199qYf$B\"!\u0007\u0003\u0014\tU!q\u0003B\r\u00057Aa!a\r@\u0001\u0004!\u0007BBA\u001b\u007f\u0001\u0007A\r\u0003\u0004\u00028}\u0002\r\u0001\u001a\u0005\u0007\u0003sy\u0004\u0019\u00013\t\u000f\u0005=r\b1\u0001\u0002\b!\u001aq(a-\u0015\u0015\u0005e!\u0011\u0005B\u0012\u0005K\u00119\u0003\u0003\u0004\u00024\u0001\u0003\r\u0001\u001a\u0005\u0007\u0003k\u0001\u0005\u0019\u00013\t\r\u0005e\u0002\t1\u0001e\u0011%\ty\u0003\u0011I\u0001\u0002\u0004\t9\u0001K\u0002A\u0003g\u000bq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005_QC!a\u0002\u00032-\u0012!1\u0007\t\u0005\u0005k\u0011i$\u0004\u0002\u00038)!!\u0011\bB\u001e\u0003%)hn\u00195fG.,GMC\u0002\u0002:\u001aLAAa\u0010\u00038\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015\r\u0005e!1\tB#\u0011\u001d\tYC\u0011a\u0001\u0003\u000fAq!a\fC\u0001\u0004\t9\u0001K\u0002C\u0003g#B!!\u0007\u0003L!9\u00111O\"A\u0002\u0005U\u0004fA\"\u00024\u0006\t2\u000f^8sC\u001e,G*\u001a<fY\u000e\u000b7\r[3\u0016\u0005\tM\u0003\u0003\u0003B+\u0005?\nI\"!\u0007\u000e\u0005\t]#\u0002\u0002B-\u00057\n!bY8oGV\u0014(/\u001a8u\u0015\r\u0011i\u0006W\u0001\u0005kRLG.\u0003\u0003\u0003b\t]#!E\"p]\u000e,(O]3oi\"\u000b7\u000f['ba\u0006\u00112\u000f^8sC\u001e,G*\u001a<fY\u000e\u000b7\r[3!\u0003U9W\r^\"bG\",Gm\u0015;pe\u0006<W\rT3wK2$B!!\u0007\u0003j!9!1\u000e$A\u0002\u0005e\u0011!\u00027fm\u0016d\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S\u0007")
public class StorageLevel
implements Externalizable {
    private boolean _useDisk;
    private boolean _useMemory;
    private boolean _useOffHeap;
    private boolean _deserialized;
    private int _replication;

    @DeveloperApi
    public static StorageLevel apply(ObjectInput objectInput) {
        return StorageLevel$.MODULE$.apply(objectInput);
    }

    @DeveloperApi
    public static StorageLevel apply(int n, int n2) {
        return StorageLevel$.MODULE$.apply(n, n2);
    }

    public static int apply$default$4() {
        return StorageLevel$.MODULE$.apply$default$4();
    }

    @DeveloperApi
    public static StorageLevel apply(boolean bl, boolean bl2, boolean bl3, int n) {
        return StorageLevel$.MODULE$.apply(bl, bl2, bl3, n);
    }

    @DeveloperApi
    public static StorageLevel apply(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        return StorageLevel$.MODULE$.apply(bl, bl2, bl3, bl4, n);
    }

    @DeveloperApi
    public static StorageLevel fromString(String string) {
        return StorageLevel$.MODULE$.fromString(string);
    }

    public static StorageLevel OFF_HEAP() {
        return StorageLevel$.MODULE$.OFF_HEAP();
    }

    public static StorageLevel MEMORY_AND_DISK_SER_2() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2();
    }

    public static StorageLevel MEMORY_AND_DISK_SER() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER();
    }

    public static StorageLevel MEMORY_AND_DISK_2() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_2();
    }

    public static StorageLevel MEMORY_AND_DISK() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public static StorageLevel MEMORY_ONLY_SER_2() {
        return StorageLevel$.MODULE$.MEMORY_ONLY_SER_2();
    }

    public static StorageLevel MEMORY_ONLY_SER() {
        return StorageLevel$.MODULE$.MEMORY_ONLY_SER();
    }

    public static StorageLevel MEMORY_ONLY_2() {
        return StorageLevel$.MODULE$.MEMORY_ONLY_2();
    }

    public static StorageLevel MEMORY_ONLY() {
        return StorageLevel$.MODULE$.MEMORY_ONLY();
    }

    public static StorageLevel DISK_ONLY_2() {
        return StorageLevel$.MODULE$.DISK_ONLY_2();
    }

    public static StorageLevel DISK_ONLY() {
        return StorageLevel$.MODULE$.DISK_ONLY();
    }

    public static StorageLevel NONE() {
        return StorageLevel$.MODULE$.NONE();
    }

    private boolean _useDisk() {
        return this._useDisk;
    }

    private void _useDisk_$eq(boolean x$1) {
        this._useDisk = x$1;
    }

    private boolean _useMemory() {
        return this._useMemory;
    }

    private void _useMemory_$eq(boolean x$1) {
        this._useMemory = x$1;
    }

    private boolean _useOffHeap() {
        return this._useOffHeap;
    }

    private void _useOffHeap_$eq(boolean x$1) {
        this._useOffHeap = x$1;
    }

    private boolean _deserialized() {
        return this._deserialized;
    }

    private void _deserialized_$eq(boolean x$1) {
        this._deserialized = x$1;
    }

    private int _replication() {
        return this._replication;
    }

    private void _replication_$eq(int x$1) {
        this._replication = x$1;
    }

    public boolean useDisk() {
        return this._useDisk();
    }

    public boolean useMemory() {
        return this._useMemory();
    }

    public boolean useOffHeap() {
        return this._useOffHeap();
    }

    public boolean deserialized() {
        return this._deserialized();
    }

    public int replication() {
        return this._replication();
    }

    public MemoryMode memoryMode() {
        return this.useOffHeap() ? MemoryMode.OFF_HEAP : MemoryMode.ON_HEAP;
    }

    public StorageLevel clone() {
        return new StorageLevel(this.useDisk(), this.useMemory(), this.useOffHeap(), this.deserialized(), this.replication());
    }

    public boolean equals(Object other) {
        StorageLevel storageLevel;
        Object object = other;
        boolean bl = object instanceof StorageLevel ? (storageLevel = (StorageLevel)object).useDisk() == this.useDisk() && storageLevel.useMemory() == this.useMemory() && storageLevel.useOffHeap() == this.useOffHeap() && storageLevel.deserialized() == this.deserialized() && storageLevel.replication() == this.replication() : false;
        return bl;
    }

    public boolean isValid() {
        return (this.useMemory() || this.useDisk()) && this.replication() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public int toInt() {
        void var1_1;
        block3: {
            int ret = 0;
            if (this._useDisk()) {
                ret |= 8;
            }
            if (this._useMemory()) {
                ret |= 4;
            }
            if (this._useOffHeap()) {
                ret |= 2;
            }
            if (!this._deserialized()) break block3;
            ret |= 1;
        }
        return (int)var1_1;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            out.writeByte(this.toInt());
            out.writeByte(this._replication());
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte flags = in.readByte();
            this._useDisk_$eq((flags & 8) != 0);
            this._useMemory_$eq((flags & 4) != 0);
            this._useOffHeap_$eq((flags & 2) != 0);
            this._deserialized_$eq((flags & 1) != 0);
            this._replication_$eq(in.readByte());
        });
    }

    private Object readResolve() throws IOException {
        return StorageLevel$.MODULE$.getCachedStorageLevel(this);
    }

    public String toString() {
        String disk = this.useDisk() ? "disk" : "";
        String memory = this.useMemory() ? "memory" : "";
        String heap = this.useOffHeap() ? "offheap" : "";
        String deserialize = this.deserialized() ? "deserialized" : "";
        Seq output = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{disk, memory, heap, deserialize, new StringBuilder(9).append(this.replication()).append(" replicas").toString()}))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StorageLevel.$anonfun$toString$1(x$1)));
        return new StringBuilder(14).append("StorageLevel(").append(output.mkString(", ")).append(")").toString();
    }

    public int hashCode() {
        return this.toInt() * 41 + this.replication();
    }

    /*
     * WARNING - void declaration
     */
    public String description() {
        void var1_1;
        String result = "";
        result = new StringBuilder(0).append(result).append((Object)(this.useDisk() ? "Disk " : "")).toString();
        if (this.useMemory()) {
            result = new StringBuilder(0).append(result).append((Object)(this.useOffHeap() ? "Memory (off heap) " : "Memory ")).toString();
        }
        result = new StringBuilder(0).append(result).append((Object)(this.deserialized() ? "Deserialized " : "Serialized ")).toString();
        result = new StringBuilder(12).append(result).append(this.replication()).append("x Replicated").toString();
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$toString$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public StorageLevel(boolean _useDisk, boolean _useMemory, boolean _useOffHeap, boolean _deserialized, int _replication) {
        block0: {
            this._useDisk = _useDisk;
            this._useMemory = _useMemory;
            this._useOffHeap = _useOffHeap;
            this._deserialized = _deserialized;
            this._replication = _replication;
            Predef$.MODULE$.assert(this.replication() < 40, (Function0 & Serializable & scala.Serializable)() -> "Replication restricted to be less than 40 for calculating hash codes");
            if (!this.useOffHeap()) break block0;
            Predef$.MODULE$.require(!this.deserialized(), (Function0 & Serializable & scala.Serializable)() -> "Off-heap storage level does not support deserialized storage");
        }
    }

    public StorageLevel(int flags, int replication) {
        this((flags & 8) != 0, (flags & 4) != 0, (flags & 2) != 0, (flags & 1) != 0, replication);
    }

    public StorageLevel() {
        this(false, true, false, false, StorageLevel$.MODULE$.org$apache$spark$storage$StorageLevel$$$lessinit$greater$default$5());
    }
}

