/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.ui.PagedDataSource;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.jobs.StageTableRowData;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!B\t\u0013\u0001Qa\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u00115\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\n\u0013\u0002\u0011\t\u0011)A\u0005\u00156C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t/\u0002\u0011\t\u0011)A\u00051\")1\f\u0001C\u00019\"9A\r\u0001b\u0001\n\u0013)\u0007BB6\u0001A\u0003%a\rC\u0005m\u0001\u0001\u0007\t\u0019!C\u0005[\"I\u0011\u000f\u0001a\u0001\u0002\u0004%IA\u001d\u0005\nq\u0002\u0001\r\u0011!Q!\n9DQ!\u001f\u0001\u0005BiDQa\u001f\u0001\u0005BqDq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\u0003\u001fM#\u0018mZ3ECR\f7k\\;sG\u0016T!a\u0005\u000b\u0002\t)|'m\u001d\u0006\u0003+Y\t!!^5\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\"\u0001A\u000f\u0011\u0007yy\u0012%D\u0001\u0015\u0013\t\u0001CCA\bQC\u001e,G\rR1uCN{WO]2f!\t\u00113%D\u0001\u0013\u0013\t!#CA\tTi\u0006<W\rV1cY\u0016\u0014vn\u001e#bi\u0006\fQa\u001d;pe\u0016\u001c\u0001\u0001\u0005\u0002)W5\t\u0011F\u0003\u0002+-\u000511\u000f^1ukNL!\u0001L\u0015\u0003\u001d\u0005\u0003\bo\u0015;biV\u001c8\u000b^8sK\u000611\u000f^1hKN\u00042aL\u001d=\u001d\t\u0001dG\u0004\u00022i5\t!G\u0003\u00024M\u00051AH]8pizJ\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oa\nq\u0001]1dW\u0006<WMC\u00016\u0013\tQ4HA\u0002TKFT!a\u000e\u001d\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015A\u0001<2\u0015\t\t\u0015&A\u0002ba&L!a\u0011 \u0003\u0013M#\u0018mZ3ECR\f\u0017aC2veJ,g\u000e\u001e+j[\u0016\u0004\"AR$\u000e\u0003aJ!\u0001\u0013\u001d\u0003\t1{gnZ\u0001\ta\u0006<WmU5{KB\u0011aiS\u0005\u0003\u0019b\u00121!\u00138u\u0013\tIu$\u0001\u0006t_J$8i\u001c7v[:\u0004\"\u0001\u0015+\u000f\u0005E\u0013\u0006CA\u00199\u0013\t\u0019\u0006(\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*9\u0003\u0011!Wm]2\u0011\u0005\u0019K\u0016B\u0001.9\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDcB/_?\u0002\f'm\u0019\t\u0003E\u0001AQ!J\u0004A\u0002\u001dBQ!L\u0004A\u00029BQ\u0001R\u0004A\u0002\u0015CQ!S\u0004A\u0002)CQAT\u0004A\u0002=CQaV\u0004A\u0002a\u000bA\u0001Z1uCV\ta\rE\u0002hU\u0006j\u0011\u0001\u001b\u0006\u0003Sb\n!bY8mY\u0016\u001cG/[8o\u0013\tQ\u0004.A\u0003eCR\f\u0007%A\b`g2L7-\u001a3Ti\u0006<W-\u00133t+\u0005q\u0007c\u0001)p\u0015&\u0011\u0001O\u0016\u0002\u0004'\u0016$\u0018aE0tY&\u001cW\rZ*uC\u001e,\u0017\nZ:`I\u0015\fHCA:w!\t1E/\u0003\u0002vq\t!QK\\5u\u0011\u001d98\"!AA\u00029\f1\u0001\u001f\u00132\u0003Ay6\u000f\\5dK\u0012\u001cF/Y4f\u0013\u0012\u001c\b%\u0001\u0005eCR\f7+\u001b>f+\u0005Q\u0015!C:mS\u000e,G)\u0019;b)\u0011ih0!\u0001\u0011\u0007=J\u0014\u0005C\u0003\u0000\u001d\u0001\u0007!*\u0001\u0003ge>l\u0007BBA\u0002\u001d\u0001\u0007!*\u0001\u0002u_\u0006A1\u000f^1hKJ{w\u000fF\u0002\"\u0003\u0013Aa!a\u0003\u0010\u0001\u0004a\u0014!C:uC\u001e,G)\u0019;b\u0003!y'\u000fZ3sS:<GCBA\t\u0003/\tI\u0002\u0005\u00030\u0003'\t\u0013bAA\u000bw\tAqJ\u001d3fe&tw\rC\u0003O!\u0001\u0007q\nC\u0003X!\u0001\u0007\u0001\f")
public class StageDataSource
extends PagedDataSource<StageTableRowData> {
    private final long currentTime;
    private final Seq<StageTableRowData> data;
    private Set<Object> _slicedStageIds;

    private Seq<StageTableRowData> data() {
        return this.data;
    }

    private Set<Object> _slicedStageIds() {
        return this._slicedStageIds;
    }

    private void _slicedStageIds_$eq(Set<Object> x$1) {
        this._slicedStageIds = x$1;
    }

    @Override
    public int dataSize() {
        return this.data().size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<StageTableRowData> sliceData(int from, int to) {
        void var3_3;
        Seq r = (Seq)this.data().slice(from, to);
        this._slicedStageIds_$eq((Set<Object>)((TraversableOnce)r.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.stageId()), Seq$.MODULE$.canBuildFrom())).toSet());
        return var3_3;
    }

    private StageTableRowData stageRow(StageData stageData) {
        String string;
        Option<Date> option = stageData.submissionTime();
        if (option instanceof Some) {
            Some some = (Some)option;
            Date t = (Date)some.value();
            string = UIUtils$.MODULE$.formatDate(t);
        } else if (None$.MODULE$.equals(option)) {
            string = "Unknown";
        } else {
            throw new MatchError(option);
        }
        String formattedSubmissionTime = string;
        long finishTime = BoxesRunTime.unboxToLong((Object)stageData.completionTime().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.currentTime));
        Option duration = stageData.firstTaskLaunchedTime().map((Function1 & Serializable & scala.Serializable)date -> BoxesRunTime.boxToLong((long)StageDataSource.$anonfun$stageRow$3(this, finishTime, date)));
        String formattedDuration = (String)duration.map((Function1 & Serializable & scala.Serializable)d -> UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)d))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown");
        long inputRead = stageData.inputBytes();
        String inputReadWithUnit = inputRead > 0L ? Utils$.MODULE$.bytesToString(inputRead) : "";
        long outputWrite = stageData.outputBytes();
        String outputWriteWithUnit = outputWrite > 0L ? Utils$.MODULE$.bytesToString(outputWrite) : "";
        long shuffleRead = stageData.shuffleReadBytes();
        String shuffleReadWithUnit = shuffleRead > 0L ? Utils$.MODULE$.bytesToString(shuffleRead) : "";
        long shuffleWrite = stageData.shuffleWriteBytes();
        String shuffleWriteWithUnit = shuffleWrite > 0L ? Utils$.MODULE$.bytesToString(shuffleWrite) : "";
        return new StageTableRowData(stageData, (Option<StageData>)new Some((Object)stageData), stageData.stageId(), stageData.attemptId(), stageData.schedulingPool(), stageData.description(), (Date)stageData.submissionTime().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Date(0L)), formattedSubmissionTime, BoxesRunTime.unboxToLong((Object)duration.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), formattedDuration, inputRead, inputReadWithUnit, outputWrite, outputWriteWithUnit, shuffleRead, shuffleReadWithUnit, shuffleWrite, shuffleWriteWithUnit);
    }

    private Ordering<StageTableRowData> ordering(String sortColumn, boolean desc) {
        Ordering ordering;
        String string = sortColumn;
        if ("Stage Id".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.stageId()), (Ordering)Ordering.Int$.MODULE$);
        } else if ("Pool Name".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$11 -> x$11.schedulingPool(), (Ordering)Ordering.String$.MODULE$);
        } else if ("Description".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x.descriptionOption(), (Object)x.stage().name()), Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.Option((Ordering)Ordering.String$.MODULE$), (Ordering)Ordering.String$.MODULE$));
        } else if ("Submitted".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$12 -> x$12.submissionTime(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        } else if ("Duration".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.duration()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Input".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.inputRead()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Output".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.outputWrite()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Shuffle Read".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.shuffleRead()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Shuffle Write".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.shuffleWrite()), (Ordering)Ordering.Long$.MODULE$);
        } else {
            if ("Tasks: Succeeded/Total".equals(string)) {
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsortable column: ").append(sortColumn).toString());
            }
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown column: ").append(string).toString());
        }
        Ordering ordering2 = ordering;
        return desc ? ordering2.reverse() : ordering2;
    }

    public static final /* synthetic */ long $anonfun$stageRow$3(StageDataSource $this, long finishTime$1, Date date) {
        long time = date.getTime();
        return finishTime$1 > time ? finishTime$1 - time : $this.currentTime - time;
    }

    public StageDataSource(AppStatusStore store, Seq<StageData> stages, long currentTime, int pageSize, String sortColumn, boolean desc) {
        this.currentTime = currentTime;
        super(pageSize);
        this.data = (Seq)((SeqLike)stages.map((Function1 & Serializable & scala.Serializable)stageData -> this.stageRow((StageData)stageData), Seq$.MODULE$.canBuildFrom())).sorted(this.ordering(sortColumn, desc));
    }
}

