/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.TaskLocality$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.AppStatusUtils$;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetrics;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.ui.jobs.StagesTab;
import org.apache.spark.ui.jobs.TaskPagedTable;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\u0006\r\u000191\u0002\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\t\u0011\u0005\u0002!\u0011!Q\u0001\n\tBQ\u0001\u000b\u0001\u0005\u0002%Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00048\u0001\u0001\u0006Ia\f\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019q\u0004\u0001)A\u0005u!)q\b\u0001C\u0005\u0001\")A\u000b\u0001C\u0001+\")a\u000e\u0001C\u0001_\nI1\u000b^1hKB\u000bw-\u001a\u0006\u0003\u001b9\tAA[8cg*\u0011q\u0002E\u0001\u0003k&T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\n\u0003\u0001]\u0001\"\u0001G\r\u000e\u00039I!A\u0007\b\u0003\u0013]+'-V%QC\u001e,\u0017A\u00029be\u0016tGo\u0001\u0001\u0011\u0005yyR\"\u0001\u0007\n\u0005\u0001b!!C*uC\u001e,7\u000fV1c\u0003\u0015\u0019Ho\u001c:f!\t\u0019c%D\u0001%\u0015\t)\u0003#\u0001\u0004ti\u0006$Xo]\u0005\u0003O\u0011\u0012a\"\u00119q'R\fG/^:Ti>\u0014X-\u0001\u0004=S:LGO\u0010\u000b\u0004U-b\u0003C\u0001\u0010\u0001\u0011\u0015Y2\u00011\u0001\u001e\u0011\u0015\t3\u00011\u0001#\u0003=!\u0016*T#M\u0013:+u\fT#H\u000b:#U#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014a\u0001=nY*\tA'A\u0003tG\u0006d\u0017-\u0003\u00027c\t!Q\t\\3n\u0003A!\u0016*T#M\u0013:+u\fT#H\u000b:#\u0005%\u0001\nN\u0003b{F+S'F\u0019&sUi\u0018+B'.\u001bV#\u0001\u001e\u0011\u0005mbT\"A\u001a\n\u0005u\u001a$aA%oi\u0006\u0019R*\u0011-`)&kU\tT%O\u000b~#\u0016iU&TA\u0005Ar-\u001a;M_\u000e\fG.\u001b;z'VlW.\u0019:z'R\u0014\u0018N\\4\u0015\u0005\u0005c\u0005C\u0001\"J\u001d\t\u0019u\t\u0005\u0002Eg5\tQI\u0003\u0002G9\u00051AH]8pizJ!\u0001S\u001a\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011NBQ!\u0014\u0005A\u00029\u000bq\u0002\\8dC2LG/_*v[6\f'/\u001f\t\u0005\u0005>\u000b\u0015+\u0003\u0002Q\u0017\n\u0019Q*\u00199\u0011\u0005m\u0012\u0016BA*4\u0005\u0011auN\\4\u0002\rI,g\u000eZ3s)\t1&\rE\u0002X9~s!\u0001\u0017.\u000f\u0005\u0011K\u0016\"\u0001\u001b\n\u0005m\u001b\u0014a\u00029bG.\fw-Z\u0005\u0003;z\u00131aU3r\u0015\tY6\u0007\u0005\u00021A&\u0011\u0011-\r\u0002\u0005\u001d>$W\rC\u0003d\u0013\u0001\u0007A-A\u0004sKF,Xm\u001d;\u0011\u0005\u0015dW\"\u00014\u000b\u0005\u001dD\u0017\u0001\u00025uiBT!!\u001b6\u0002\u000fM,'O\u001e7fi*\t1.A\u0003kCZ\f\u00070\u0003\u0002nM\n\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u00031i\u0017m[3US6,G.\u001b8f)51\u0006o_?\u0000\u0003\u0007\t9!a\u0003\u0002\u0010!)\u0011O\u0003a\u0001e\u0006)A/Y:lgB\u0019q\u000bX:\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018A\u0001<2\u0015\tAH%A\u0002ba&L!A_;\u0003\u0011Q\u000b7o\u001b#bi\u0006DQ\u0001 \u0006A\u0002E\u000b1bY;se\u0016tG\u000fV5nK\")aP\u0003a\u0001u\u0005!\u0001/Y4f\u0011\u0019\t\tA\u0003a\u0001u\u0005A\u0001/Y4f'&TX\r\u0003\u0004\u0002\u0006)\u0001\rAO\u0001\u000bi>$\u0018\r\u001c)bO\u0016\u001c\bBBA\u0005\u0015\u0001\u0007!(A\u0004ti\u0006<W-\u00133\t\r\u00055!\u00021\u0001;\u00039\u0019H/Y4f\u0003R$X-\u001c9u\u0013\u0012Da!!\u0005\u000b\u0001\u0004Q\u0014A\u0003;pi\u0006dG+Y:lg\u0002")
public class StagePage
extends WebUIPage {
    private final StagesTab parent;
    private final AppStatusStore store;
    private final Elem TIMELINE_LEGEND;
    private final int MAX_TIMELINE_TASKS;

    private Elem TIMELINE_LEGEND() {
        return this.TIMELINE_LEGEND;
    }

    private int MAX_TIMELINE_TASKS() {
        return this.MAX_TIMELINE_TASKS;
    }

    private String getLocalitySummaryString(Map<String, Object> localitySummary) {
        Map names = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.PROCESS_LOCAL().toString()), (Object)"Process local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.NODE_LOCAL().toString()), (Object)"Node local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.RACK_LOCAL().toString()), (Object)"Rack local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.ANY().toString()), (Object)"Any")}));
        Seq localityNamesAndCounts = ((TraversableOnce)names.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String name = (String)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(localitySummary.get((Object)key).map((Function1 & Serializable & scala.Serializable)count -> StagePage.$anonfun$getLocalitySummaryString$2(name, BoxesRunTime.unboxToLong((Object)count))));
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return ((TraversableOnce)localityNamesAndCounts.sorted((Ordering)Ordering.String$.MODULE$)).mkString("; ");
    }

    @Override
    public Seq<Node> render(HttpServletRequest request) {
        Seq<Node> seq;
        Object object = new Object();
        try {
            TaskPagedTable taskPagedTable2;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            String parameterId = request.getParameter("id");
            Predef$.MODULE$.require(parameterId != null && new StringOps(Predef$.MODULE$.augmentString(parameterId)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing id parameter");
            String parameterAttempt = request.getParameter("attempt");
            Predef$.MODULE$.require(parameterAttempt != null && new StringOps(Predef$.MODULE$.augmentString(parameterAttempt)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing attempt parameter");
            String parameterTaskSortColumn = request.getParameter("task.sort");
            String parameterTaskSortDesc = request.getParameter("task.desc");
            String parameterTaskPageSize = request.getParameter("task.pageSize");
            String eventTimelineParameterTaskPage = request.getParameter("task.eventTimelinePageNumber");
            String eventTimelineParameterTaskPageSize = request.getParameter("task.eventTimelinePageSize");
            IntRef eventTimelineTaskPage = IntRef.create((int)BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)eventTimelineParameterTaskPage).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StagePage.$anonfun$render$3(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1)));
            IntRef eventTimelineTaskPageSize = IntRef.create((int)BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)eventTimelineParameterTaskPageSize).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StagePage.$anonfun$render$5(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100)));
            String taskSortColumn = (String)Option$.MODULE$.apply((Object)parameterTaskSortColumn).map((Function1 & Serializable & scala.Serializable)sortColumn -> UIUtils$.MODULE$.decodeURLParameter((String)sortColumn)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Index");
            boolean taskSortDesc = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)parameterTaskSortDesc).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StagePage.$anonfun$render$9(x$3))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            int taskPageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterTaskPageSize).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StagePage.$anonfun$render$11(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100));
            int stageId = new StringOps(Predef$.MODULE$.augmentString(parameterId)).toInt();
            int stageAttemptId = new StringOps(Predef$.MODULE$.augmentString(parameterAttempt)).toInt();
            String stageHeader = new StringBuilder(29).append("Details for Stage ").append(stageId).append(" (Attempt ").append(stageAttemptId).append(")").toString();
            Tuple2 tuple2 = (Tuple2)this.parent.store().asOption((Function0 & Serializable & scala.Serializable)() -> $this.parent.store().stageAttempt(stageId, stageAttemptId, false)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("No information to display for Stage "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)stageId));
                $buf2.$amp$plus((Object)new Text(" (Attempt "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)stageAttemptId));
                $buf2.$amp$plus((Object)new Text(")"));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem content = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                throw new NonLocalReturnControl(object, UIUtils$.MODULE$.headerSparkPage(request, stageHeader, (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> content, $this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7()));
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StageData stageData = (StageData)tuple2._1();
            Seq stageJobIds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)stageData, (Object)stageJobIds);
            Tuple2 tuple23 = tuple22;
            StageData stageData2 = (StageData)tuple23._1();
            Seq stageJobIds2 = (Seq)tuple23._2();
            Map<String, Object> localitySummary = this.store.localitySummary(stageData2.stageId(), stageData2.attemptId());
            int totalTasks = stageData2.numActiveTasks() + stageData2.numCompleteTasks() + stageData2.numFailedTasks() + stageData2.numKilledTasks();
            if (totalTasks == 0) {
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("Summary Metrics"));
                $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text(" No tasks have started yet\n          "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("Tasks"));
                $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf.$amp$plus((Object)new Text(" No tasks have started yet\n        "));
                Elem content = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                return UIUtils$.MODULE$.headerSparkPage(request, stageHeader, (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> content, this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
            }
            if (eventTimelineTaskPageSize.elem < 1 || eventTimelineTaskPageSize.elem > totalTasks) {
                eventTimelineTaskPageSize.elem = totalTasks;
            }
            int eventTimelineTotalPages = (totalTasks + eventTimelineTaskPageSize.elem - 1) / eventTimelineTaskPageSize.elem;
            if (eventTimelineTaskPage.elem < 1 || eventTimelineTaskPage.elem > eventTimelineTotalPages) {
                eventTimelineTaskPage.elem = 1;
            }
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Total Time Across All Tasks: "));
            $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)UIUtils$.MODULE$.formatDuration(stageData2.executorRunTime()));
            $buf5.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("Locality Level Summary: "));
            $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)this.getLocalitySummaryString(localitySummary));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasInput(stageData2)) {
                NodeBuffer $buf9 = new NodeBuffer();
                $buf9.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf10 = new NodeBuffer();
                $buf10.$amp$plus((Object)new Text("Input Size / Records: "));
                $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
                $buf9.$amp$plus((Object)new Text("\n              "));
                $buf9.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString(stageData2.inputBytes())).append(" / ").append(stageData2.inputRecords()).toString());
                $buf9.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9);
                boxedUnit6 = elem;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit6);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasOutput(stageData2)) {
                NodeBuffer $buf11 = new NodeBuffer();
                $buf11.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf12 = new NodeBuffer();
                $buf12.$amp$plus((Object)new Text("Output Size / Records: "));
                $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
                $buf11.$amp$plus((Object)new Text("\n              "));
                $buf11.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString(stageData2.outputBytes())).append(" / ").append(stageData2.outputRecords()).toString());
                $buf11.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11);
                boxedUnit5 = elem;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit5);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasShuffleRead(stageData2)) {
                NodeBuffer $buf13 = new NodeBuffer();
                $buf13.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf14 = new NodeBuffer();
                $buf14.$amp$plus((Object)new Text("Shuffle Read Size / Records: "));
                $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
                $buf13.$amp$plus((Object)new Text("\n              "));
                $buf13.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString(stageData2.shuffleReadBytes())).append(" / ").append(stageData2.shuffleReadRecords()).toString());
                $buf13.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13);
                boxedUnit4 = elem;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit4);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasShuffleWrite(stageData2)) {
                NodeBuffer $buf15 = new NodeBuffer();
                $buf15.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf16 = new NodeBuffer();
                $buf16.$amp$plus((Object)new Text("Shuffle Write Size / Records: "));
                $buf15.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
                $buf15.$amp$plus((Object)new Text("\n               "));
                $buf15.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString(stageData2.shuffleWriteBytes())).append(" / ").append(stageData2.shuffleWriteRecords()).toString());
                $buf15.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15);
                boxedUnit3 = elem;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit3);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasBytesSpilled(stageData2)) {
                NodeBuffer $buf17 = new NodeBuffer();
                NodeBuffer $buf18 = new NodeBuffer();
                $buf18.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf19 = new NodeBuffer();
                $buf19.$amp$plus((Object)new Text("Spill (Memory): "));
                $buf18.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19));
                $buf18.$amp$plus((Object)new Text("\n              "));
                $buf18.$amp$plus((Object)Utils$.MODULE$.bytesToString(stageData2.memoryBytesSpilled()));
                $buf18.$amp$plus((Object)new Text("\n            "));
                $buf17.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
                NodeBuffer $buf20 = new NodeBuffer();
                $buf20.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf21 = new NodeBuffer();
                $buf21.$amp$plus((Object)new Text("Spill (Disk): "));
                $buf20.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21));
                $buf20.$amp$plus((Object)new Text("\n              "));
                $buf20.$amp$plus((Object)Utils$.MODULE$.bytesToString(stageData2.diskBytesSpilled()));
                $buf20.$amp$plus((Object)new Text("\n            "));
                $buf17.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
                boxedUnit2 = $buf17;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit2);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (!stageJobIds2.isEmpty()) {
                NodeBuffer $buf22 = new NodeBuffer();
                $buf22.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf23 = new NodeBuffer();
                $buf23.$amp$plus((Object)new Text("Associated Job Ids: "));
                $buf22.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
                $buf22.$amp$plus((Object)new Text("\n              "));
                $buf22.$amp$plus(((TraversableLike)stageJobIds2.sorted((Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)jobId -> StagePage.$anonfun$render$17(this, request, BoxesRunTime.unboxToInt((Object)jobId)), Seq$.MODULE$.canBuildFrom()));
                $buf22.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22);
                boxedUnit = elem;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit);
            $buf4.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            Option stageGraph = this.parent.store().asOption((Function0 & Serializable & scala.Serializable)() -> $this.parent.store().operationGraphForStage(stageId));
            Seq<Node> dagViz = UIUtils$.MODULE$.showDagVizForStage(stageId, stageGraph);
            long currentTime = System.currentTimeMillis();
            try {
                TaskPagedTable _taskTable;
                taskPagedTable2 = _taskTable = new TaskPagedTable(stageData2, new StringBuilder(27).append(UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3())).append("/stages/stage/?id=").append(stageId).append("&attempt=").append(stageAttemptId).toString(), currentTime, taskPageSize, taskSortColumn, taskSortDesc, this.parent.store());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException;
                if (!bl) {
                    throw throwable;
                }
                TaskPagedTable taskPagedTable3 = null;
                taskPagedTable2 = taskPagedTable3;
            }
            TaskPagedTable taskTable = taskPagedTable2;
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("id", (Seq)new Text("showAdditionalMetrics"), (MetaData)$md2);
            TraversableLike traversableLike = (TraversableLike)((TraversableLike)((TraversableLike)summary.$plus$plus(dagViz, NodeSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])), NodeSeq$.MODULE$.canBuildFrom())).$plus$plus(this.makeTimeline((Seq<TaskData>)((Seq)Option$.MODULE$.apply((Object)taskTable).map((Function1 & Serializable & scala.Serializable)taskPagedTable -> {
                int from = (eventTimelineTaskPage$1.elem - 1) * eventTimelineTaskPageSize$1.elem;
                int to = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(taskPagedTable.dataSource().dataSize()), eventTimelineTaskPage$1.elem * eventTimelineTaskPageSize$1.elem);
                return taskPagedTable.dataSource().sliceData(from, to);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), currentTime, eventTimelineTaskPage.elem, eventTimelineTaskPageSize.elem, eventTimelineTotalPages, stageId, stageAttemptId, totalTasks), NodeSeq$.MODULE$.canBuildFrom());
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("id", (Seq)new Text("parent-container"), (MetaData)$md3);
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("\n          "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("src", UIUtils$.MODULE$.prependBaseUri(request, "/static/utils.js", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md4);
            $buf24.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf24.$amp$plus((Object)new Text("\n          "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("src", UIUtils$.MODULE$.prependBaseUri(request, "/static/stagepage.js", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md5);
            $buf24.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf24.$amp$plus((Object)new Text("\n        "));
            NodeSeq content = (NodeSeq)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24), NodeSeq$.MODULE$.canBuildFrom());
            HttpServletRequest x$12 = request;
            String x$22 = stageHeader;
            Function0 & Serializable & scala.Serializable x$32 = (Function0 & Serializable & scala.Serializable)() -> content;
            StagesTab x$42 = this.parent;
            boolean x$5 = true;
            boolean x$6 = true;
            Option<String> x$7 = UIUtils$.MODULE$.headerSparkPage$default$5();
            seq = UIUtils$.MODULE$.headerSparkPage(x$12, x$22, (Function0<Seq<Node>>)x$32, x$42, x$7, x$5, x$6);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq<Node>)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public Seq<Node> makeTimeline(Seq<TaskData> tasks, long currentTime, int page, int pageSize, int totalPages, int stageId, int stageAttemptId, int totalTasks) {
        Elem elem;
        HashSet executorsSet = new HashSet();
        LongRef minLaunchTime = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxFinishTime = LongRef.create((long)Long.MIN_VALUE);
        String executorsArrayStr = ((TraversableOnce)((TraversableLike)((IterableLike)tasks.sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$1(x$6)), (Ordering)Ordering.Long$.MODULE$)).take(this.MAX_TIMELINE_TASKS())).map((Function1 & Serializable & scala.Serializable)taskInfo -> {
            String executorId = taskInfo.executorId();
            String host = taskInfo.host();
            executorsSet.$plus$eq((Object)new Tuple2((Object)executorId, (Object)host));
            long launchTime = taskInfo.launchTime().getTime();
            long finishTime = BoxesRunTime.unboxToLong((Object)taskInfo.duration().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$7 -> taskInfo.launchTime().getTime() + x$7).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> currentTime));
            long totalExecutionTime = finishTime - launchTime;
            minLaunchTime$1.elem = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(launchTime), minLaunchTime$1.elem);
            maxFinishTime$1.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(finishTime), maxFinishTime$1.elem);
            Option<TaskMetrics> metricsOpt = taskInfo.taskMetrics();
            long shuffleReadTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$5(x$8))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            double shuffleReadTimeProportion = StagePage.toProportion$1(shuffleReadTime, totalExecutionTime);
            long shuffleWriteTime = (long)((double)BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$7(x$9))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) / 1000000.0);
            double shuffleWriteTimeProportion = StagePage.toProportion$1(shuffleWriteTime, totalExecutionTime);
            long serializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.resultSerializationTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            double serializationTimeProportion = StagePage.toProportion$1(serializationTime, totalExecutionTime);
            long deserializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.executorDeserializeTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            double deserializationTimeProportion = StagePage.toProportion$1(deserializationTime, totalExecutionTime);
            long gettingResultTime = AppStatusUtils$.MODULE$.gettingResultTime((TaskData)taskInfo);
            double gettingResultTimeProportion = StagePage.toProportion$1(gettingResultTime, totalExecutionTime);
            long schedulerDelay = AppStatusUtils$.MODULE$.schedulerDelay((TaskData)taskInfo);
            double schedulerDelayProportion = StagePage.toProportion$1(schedulerDelay, totalExecutionTime);
            long executorOverhead = serializationTime + deserializationTime;
            long executorRunTime = taskInfo.duration().isDefined() ? package$.MODULE$.max(totalExecutionTime - executorOverhead - gettingResultTime - schedulerDelay, 0L) : BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.executorRunTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max(totalExecutionTime - executorOverhead - gettingResultTime - schedulerDelay, 0L)));
            long executorComputingTime = executorRunTime - shuffleReadTime - shuffleWriteTime;
            double executorComputingTimeProportion = package$.MODULE$.max((double)100 - schedulerDelayProportion - shuffleReadTimeProportion - shuffleWriteTimeProportion - serializationTimeProportion - deserializationTimeProportion - gettingResultTimeProportion, 0.0);
            int schedulerDelayProportionPos = 0;
            double deserializationTimeProportionPos = (double)schedulerDelayProportionPos + schedulerDelayProportion;
            double shuffleReadTimeProportionPos = deserializationTimeProportionPos + deserializationTimeProportion;
            double executorRuntimeProportionPos = shuffleReadTimeProportionPos + shuffleReadTimeProportion;
            double shuffleWriteTimeProportionPos = executorRuntimeProportionPos + executorComputingTimeProportion;
            double serializationTimeProportionPos = shuffleWriteTimeProportionPos + shuffleWriteTimeProportion;
            double gettingResultTimeProportionPos = serializationTimeProportionPos + serializationTimeProportion;
            int index = taskInfo.index();
            int attempt = taskInfo.attempt();
            String svgTag = totalExecutionTime == 0L ? "<svg class=\"task-assignment-timeline-duration-bar\"></svg>" : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1090).append("<svg class=\"task-assignment-timeline-duration-bar\">\n                 |<rect class=\"scheduler-delay-proportion\"\n                   |x=\"").append(schedulerDelayProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(schedulerDelayProportion).append("%\"></rect>\n                 |<rect class=\"deserialization-time-proportion\"\n                   |x=\"").append(deserializationTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(deserializationTimeProportion).append("%\"></rect>\n                 |<rect class=\"shuffle-read-time-proportion\"\n                   |x=\"").append(shuffleReadTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(shuffleReadTimeProportion).append("%\"></rect>\n                 |<rect class=\"executor-runtime-proportion\"\n                   |x=\"").append(executorRuntimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(executorComputingTimeProportion).append("%\"></rect>\n                 |<rect class=\"shuffle-write-time-proportion\"\n                   |x=\"").append(shuffleWriteTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(shuffleWriteTimeProportion).append("%\"></rect>\n                 |<rect class=\"serialization-time-proportion\"\n                   |x=\"").append(serializationTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(serializationTimeProportion).append("%\"></rect>\n                 |<rect class=\"getting-result-time-proportion\"\n                   |x=\"").append(gettingResultTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(gettingResultTimeProportion).append("%\"></rect></svg>").toString())).stripMargin();
            String timelineObject = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(882).append("\n             |{\n               |'className': 'task task-assignment-timeline-object',\n               |'group': '").append(executorId).append("',\n               |'content': '<div class=\"task-assignment-timeline-content\"\n                 |data-toggle=\"tooltip\" data-placement=\"top\"\n                 |data-html=\"true\" data-container=\"body\"\n                 |data-title=\"").append("Task ").append(index).append(" (attempt ").append(attempt).append(")").append("<br>\n                 |Status: ").append(taskInfo.status()).append("<br>\n                 |Launch Time: ").append(UIUtils$.MODULE$.formatDate(new Date(launchTime))).append("\n                 |").append((Object)(!taskInfo.duration().isDefined() ? new StringBuilder(17).append("<br>Finish Time: ").append(UIUtils$.MODULE$.formatDate(new Date(finishTime))).toString() : "")).append("\n                 |<br>Scheduler Delay: ").append(schedulerDelay).append(" ms\n                 |<br>Task Deserialization Time: ").append(UIUtils$.MODULE$.formatDuration(deserializationTime)).append("\n                 |<br>Shuffle Read Time: ").append(UIUtils$.MODULE$.formatDuration(shuffleReadTime)).append("\n                 |<br>Executor Computing Time: ").append(UIUtils$.MODULE$.formatDuration(executorComputingTime)).append("\n                 |<br>Shuffle Write Time: ").append(UIUtils$.MODULE$.formatDuration(shuffleWriteTime)).append("\n                 |<br>Result Serialization Time: ").append(UIUtils$.MODULE$.formatDuration(serializationTime)).append("\n                 |<br>Getting Result Time: ").append(UIUtils$.MODULE$.formatDuration(gettingResultTime)).append("\">\n                 |").append(svgTag).append("',\n               |'start': new Date(").append(launchTime).append("),\n               |'end': new Date(").append(finishTime).append(")\n             |}\n           |").toString())).stripMargin().replaceAll("[\\r\\n]+", " ");
            return timelineObject;
        }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        String groupArrayStr = ((TraversableOnce)executorsSet.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String executorId = (String)tuple2._1();
            String host = (String)tuple2._2();
            String string = new StringBuilder(95).append("\n            {\n              'id': '").append(executorId).append("',\n              'content': '").append(executorId).append(" / ").append(host).append("',\n            }\n          ").toString();
            return string;
        }, HashSet$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-task-assignment-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-task-assignment-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Event Timeline"));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem2 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("id", (Seq)new Text("task-assignment-timeline"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_TASKS() < tasks.size()) {
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            This page has more than the maximum number of tasks that can be shown in the\n            visualization! Only the most recent "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_TASKS()));
            $buf4.$amp$plus((Object)new Text(" tasks\n            (of "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)tasks.size()));
            $buf4.$amp$plus((Object)new Text(" total) are shown.\n          "));
            Elem elem3 = new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4);
            elem = elem3;
        } else {
            elem = Seq$.MODULE$.empty();
        }
        $buf3.$amp$plus((Object)elem);
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("task-assignment-timeline-zoom-lock"), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md6);
        $buf6.$amp$plus((Object)new Elem(null, "input", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Enable zooming"));
        $buf6.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", (Seq)new Text("margin-bottom: 0px;"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("form-inline pull-right"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("action", (Seq)Nil$.MODULE$, (MetaData)$md7);
        $md7 = new UnprefixedAttribute("method", (Seq)new Text("get"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("id", "form-event-timeline-page", (MetaData)$md7);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Tasks: "));
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)totalTasks));
        $buf10.$amp$plus((Object)new Text(". "));
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)totalPages));
        $buf10.$amp$plus((Object)new Text(" Pages. Jump to"));
        $buf9.$amp$plus((Object)new Elem(null, "label", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("value", ((Object)BoxesRunTime.boxToInteger((int)stageId)).toString(), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("name", (Seq)new Text("id"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("hidden"), (MetaData)$md8);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("value", ((Object)BoxesRunTime.boxToInteger((int)stageAttemptId)).toString(), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("name", (Seq)new Text("attempt"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("type", (Seq)new Text("hidden"), (MetaData)$md9);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("span1"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("value", ((Object)BoxesRunTime.boxToInteger((int)page)).toString(), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("id", "form-event-timeline-page-no", (MetaData)$md10);
        $md10 = new UnprefixedAttribute("name", (Seq)new Text("task.eventTimelinePageNumber"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md10);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf9.$amp$plus((Object)new Text("\n\n            "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text(". Show "));
        $buf9.$amp$plus((Object)new Elem(null, "label", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("span1"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("value", ((Object)BoxesRunTime.boxToInteger((int)pageSize)).toString(), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("name", (Seq)new Text("task.eventTimelinePageSize"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("id", "form-event-timeline-page-size", (MetaData)$md11);
        $md11 = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md11);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("items in a page."));
        $buf9.$amp$plus((Object)new Elem(null, "label", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf9.$amp$plus((Object)new Text("\n\n            "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("class", (Seq)new Text("btn"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md12);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("Go"));
        $buf9.$amp$plus((Object)new Elem(null, "button", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)new Elem(null, "form", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)this.TIMELINE_LEGEND());
        $buf3.$amp$plus((Object)new Text("\n    "));
        TraversableLike traversableLike = (TraversableLike)elem2.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3), NodeSeq$.MODULE$.canBuildFrom());
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md13);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n      "));
        $buf14.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringBuilder(36).append("drawTaskAssignmentTimeline(").append(groupArrayStr).append(", ").append(executorsArrayStr).append(", ").append(minLaunchTime.elem).append(", ").append(maxFinishTime.elem).append(", ").append(UIUtils$.MODULE$.getTimeZoneOffset()).append(")").toString()));
        $buf14.$amp$plus((Object)new Text("\n    "));
        return (Seq)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "script", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14), NodeSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ String $anonfun$getLocalitySummaryString$2(String name$1, long count) {
        return new StringBuilder(2).append(name$1).append(": ").append(count).toString();
    }

    public static final /* synthetic */ int $anonfun$render$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ int $anonfun$render$5(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$render$9(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$render$11(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ NodeBuffer $anonfun$render$17(StagePage $this, HttpServletRequest request$1, int jobId) {
        String jobURL = new StringOps(Predef$.MODULE$.augmentString("%s/jobs/job/?id=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request$1, $this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), BoxesRunTime.boxToInteger((int)jobId)}));
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", jobURL, (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)jobId)).toString());
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new EntityRef("nbsp"));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        return $buf;
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$1(TaskData x$6) {
        return -x$6.launchTime().getTime();
    }

    private static final double toProportion$1(long time, long totalExecutionTime$1) {
        return (double)time / (double)totalExecutionTime$1 * (double)100;
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$5(TaskMetrics x$8) {
        return x$8.shuffleReadMetrics().fetchWaitTime();
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$7(TaskMetrics x$9) {
        return x$9.shuffleWriteMetrics().writeTime();
    }

    public StagePage(StagesTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("stage");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        .colon.colon legendPairs = new .colon.colon((Object)new Tuple2((Object)"scheduler-delay-proportion", (Object)"Scheduler Delay"), (List)new .colon.colon((Object)new Tuple2((Object)"deserialization-time-proportion", (Object)"Task Deserialization Time"), (List)new .colon.colon((Object)new Tuple2((Object)"shuffle-read-time-proportion", (Object)"Shuffle Read Time"), (List)new .colon.colon((Object)new Tuple2((Object)"executor-runtime-proportion", (Object)"Executor Computing Time"), (List)new .colon.colon((Object)new Tuple2((Object)"shuffle-write-time-proportion", (Object)"Shuffle Write Time"), (List)new .colon.colon((Object)new Tuple2((Object)"serialization-time-proportion", (Object)"Result Serialization Time"), (List)new .colon.colon((Object)new Tuple2((Object)"getting-result-time-proportion", (Object)"Getting Result Time"), (List)Nil$.MODULE$)))))));
        $buf2.$amp$plus(((List)legendPairs.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int index;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    index = tuple22._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String classAttr = (String)tuple2._1();
            String name = (String)tuple2._2();
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", classAttr, (MetaData)$md);
            $md = new UnprefixedAttribute("height", (Seq)new Text("10px"), (MetaData)$md);
            $md = new UnprefixedAttribute("width", (Seq)new Text("10px"), (MetaData)$md);
            $md = new UnprefixedAttribute("y", new StringBuilder(2).append(10 + index % 3 * 15).append("px").toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("x", new StringBuilder(2).append(5 + index / 3 * 210).append("px").toString(), (MetaData)$md);
            $buf.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("y", new StringBuilder(2).append(20 + index % 3 * 15).append("px").toString(), (MetaData)$md2);
            $md2 = new UnprefixedAttribute("x", new StringBuilder(2).append(25 + index / 3 * 210).append("px").toString(), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)name);
            $buf.$amp$plus((Object)new Elem(null, "text", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            NodeBuffer nodeBuffer = $buf;
            return nodeBuffer;
        }, List$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        this.TIMELINE_LEGEND = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        this.MAX_TIMELINE_TASKS = BoxesRunTime.unboxToInt((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_TASKS_MAXIMUM()));
    }
}

