/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.io;

import com.splunk.io.ChunkedOutputStream;
import com.splunk.io.SearchMetricsReporter;
import com.splunk.search.SearchResults;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class SearchOutputStream
implements SearchMetricsReporter {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String HEADER_STREAM_TYPE = "stream_type";
    public static final String STREAM_TYPE_RAW = "raw";
    public static final String STREAM_TYPE_REPORT = "report";
    public static final String STREAM_TYPE_EVENTS = "events";
    public static final String STREAM_TYPE_JOURNAL = "journal";
    static final Integer PROTOCOL_VERSION = new Integer(1);
    protected ChunkedOutputStream _out = null;
    protected Map<String, Object> _header = new HashMap<String, Object>();
    protected String _metricPrefix = "";
    protected String _stream_type = "";
    protected long _stream_id = 0L;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public SearchOutputStream(ChunkedOutputStream out) {
        this._out = out;
    }

    public SearchOutputStream(OutputStream out) {
        this(new ChunkedOutputStream(out));
    }

    public long copyAll(InputStream in, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = in.read(buf))) {
            byte[] header = this.getHeaderBytes();
            this._out.write(header, 0, header.length, buf, 0, n);
            count += (long)n;
        }
        return count;
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public void write(SearchResults srs) throws IOException {
        if (!(this._stream_type.startsWith(STREAM_TYPE_REPORT) || this._stream_type.equals(STREAM_TYPE_EVENTS) || this._stream_type.equals(STREAM_TYPE_JOURNAL))) {
            throw new IOException("Cannot serialize search results with current stream_type=" + this._stream_type);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        srs.toCSV(new OutputStreamWriter((OutputStream)baos, UTF8));
        byte[] splunk_header = String.format("splunk 6.0,%d,%d\n", 0, baos.size()).getBytes(UTF8);
        this.write(splunk_header, 0, splunk_header.length);
        this.write(baos);
    }

    public void write(ByteArrayOutputStream body) throws IOException {
        byte[] h = this.getHeaderBytes();
        this._out.write(h, 0, h.length, body);
    }

    public void write(byte[] body, int off, int len) throws IOException {
        byte[] h = this.getHeaderBytes();
        this._out.write(h, 0, h.length, body, off, len);
    }

    public void writeHeader() throws IOException {
        byte[] h = this.getHeaderBytes();
        if (h.length > 0) {
            this._out.write(h, 0, h.length, null, 0, 0);
            this._out.flush();
        }
    }

    public synchronized void setStreamType(String st) {
        if (this._stream_type.equals(st)) {
            return;
        }
        this._header.put(HEADER_STREAM_TYPE, st);
        ++this._stream_id;
        this._stream_type = st;
    }

    public synchronized String getStreamType() {
        return this._stream_type;
    }

    public synchronized void addHeader(Map<String, Object> header) {
        this._header.putAll(header);
        ++this._stream_id;
    }

    @Override
    public synchronized void addMessage(String level, String message) {
        int i = 0;
        for (String key : this._header.keySet()) {
            if (!key.startsWith("message.")) continue;
            ++i;
        }
        this._header.put("message." + i + "." + level, message);
    }

    @Override
    public synchronized void addLink(String name, String url) {
        this._header.put("link." + name, url);
    }

    public synchronized void setReportPostProcessSearch(String search) {
        this._header.put("report_postprocess_search", search);
    }

    @Override
    public synchronized void addMessage(String level, Exception e) {
        String message = String.valueOf(e.getMessage()).split("\n")[0];
        this.addMessage(level, e.getClass().getSimpleName() + " - " + message);
    }

    public synchronized void reportError(Logger logger, Exception e, StreamType streamType) {
        try {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.addMessage("ERROR", e);
            this._header.put(HEADER_STREAM_TYPE, streamType.toString());
            ++this._stream_id;
            this.writeHeader();
            this.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void setMetricPrefix(String prefix) {
        this._metricPrefix = prefix;
    }

    @Override
    public void addCountMetric(String name, long input, long output) {
        this.addMetricImpl("count_metric." + this._metricPrefix + name, input, output);
    }

    @Override
    public void addMetric(String name, long elapsed_ms, long calls) {
        this.addMetricImpl("metric." + this._metricPrefix + name, elapsed_ms, calls);
    }

    protected synchronized void addMetricImpl(String fullName, long first, long second) {
        String[] vals;
        Object val = this._header.get(fullName);
        if (val != null && (vals = val.toString().split(",")).length == 2) {
            first += Long.valueOf(vals[0].trim()).longValue();
            second += Long.valueOf(vals[1].trim()).longValue();
        }
        this._header.put(fullName, String.valueOf(first) + "," + String.valueOf(second));
    }

    protected synchronized byte[] getHeaderBytes() throws JsonGenerationException, JsonMappingException, IOException {
        if (this._header.isEmpty()) {
            return new byte[0];
        }
        if (!this._header.containsKey(HEADER_STREAM_TYPE)) {
            this._header.put(HEADER_STREAM_TYPE, this._stream_type);
        }
        this._header.put("version", PROTOCOL_VERSION);
        this._header.put("stream_id", this._stream_id);
        byte[] result = this.jsonMapper.writeValueAsString(this._header).getBytes(UTF8);
        this._header.clear();
        return result;
    }

    public static enum StreamType {
        raw,
        report,
        report_cache;

    }
}

