/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.mr.SplunkMR;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.Logger;

public class CleanupMapper
extends Mapper<Text, Text, Text, Text> {
    private static Logger gLogger = Logger.getLogger(CleanupMapper.class);
    private static Random RANDOM = new Random();
    public static String DELETE_SUFFIX = ".delete";
    public static String CLEAN_SUFFIX = ".clean";

    private static File getRandomDeleteName(File f) {
        return new File(f.getParent(), f.getName() + "." + RANDOM.nextInt(123456) + DELETE_SUFFIX);
    }

    protected void map(Text key, Text value, Mapper.Context context) throws InterruptedException, IOException {
        Configuration conf = context.getConfiguration();
        String hostname = ((FileSplit)context.getInputSplit()).getPath().getName();
        File dnHome = new File(conf.get(SplunkMR.CONF_DN_HOME));
        File localJobDir = new File(SplunkMR.getLocalJobDir(context), "cm");
        File dnHome2delete = CleanupMapper.getRandomDeleteName(dnHome);
        File cleanupFile = new File(localJobDir, dnHome.getName() + CLEAN_SUFFIX);
        long startTime = System.currentTimeMillis();
        long pollInterval = 100L;
        long dnHomeWaitLimit = 20000L;
        try {
            localJobDir.mkdirs();
            if (cleanupFile.createNewFile()) {
                if (!dnHome.exists()) {
                    gLogger.info((Object)("skipping cleanup, directory does not exist, dir=" + dnHome));
                    context.write((Object)new Text(hostname), (Object)new Text("SUCCEEDED-NO-DIR"));
                    return;
                }
                if (dnHome2delete.createNewFile()) {
                    dnHome2delete.delete();
                    if (!dnHome.renameTo(dnHome2delete)) {
                        gLogger.warn((Object)("rename of dnHome=" + dnHome + " to dir2delete=" + dnHome2delete + " failed"));
                        context.write((Object)new Text(hostname), (Object)new Text("FAILED-TO-RENAME"));
                    } else if (FileUtils.deleteQuietly((File)dnHome2delete)) {
                        gLogger.info((Object)("Successfully cleaned dir=" + dnHome + " on hostname=" + hostname));
                        context.write((Object)new Text(hostname), (Object)new Text("SUCCEEDED"));
                    } else {
                        gLogger.warn((Object)("Successfully renamed, but unable to delete, dir2delete=" + dnHome2delete));
                        context.write((Object)new Text(hostname), (Object)new Text("SUCCEEDED-RENAMED_BUT_NOT_YET_DELETED"));
                    }
                }
            } else {
                gLogger.info((Object)"Waiting for another task to run cleanup");
                while (dnHome.exists() && System.currentTimeMillis() - startTime < dnHomeWaitLimit) {
                    Thread.sleep(pollInterval);
                }
                if (dnHome.exists()) {
                    context.write((Object)new Text(hostname), (Object)new Text("FAILED-DUPLICATE-TIMEOUT"));
                    gLogger.warn((Object)("Duplicate task timed out before other task could cleanup dir=" + dnHome + ", dir2delete=" + dnHome2delete));
                } else {
                    context.write((Object)new Text(hostname), (Object)new Text("SUCCEEDED-DUPLICATE"));
                }
            }
        }
        catch (IOException ex) {
            context.write((Object)new Text(hostname), (Object)new Text("FAILED"));
            throw ex;
        }
    }
}

