/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.Cache;
import com.splunk.mr.cache.CacheReference;
import com.splunk.mr.cache.MapCache;
import com.splunk.mr.cache.merge.MergeDecider;
import com.splunk.mr.cache.merge.MergeDeleter;
import com.splunk.mr.cache.merge.MergeeTree;
import com.splunk.mr.cache.merge.Merger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class CacheMerger {
    private static final Logger gLogger = Logger.getLogger(CacheMerger.class);
    private final FileSystem fs;
    private final CacheReference cacheReference;
    private final Configuration conf;
    private final Path compactsDir;
    private final Path stableDir;

    public CacheMerger(FileSystem fs, CacheReference cacheReference, Configuration conf, Path compactsDir, Path stableDir) {
        this.fs = fs;
        this.cacheReference = cacheReference;
        this.conf = conf;
        this.compactsDir = compactsDir;
        this.stableDir = stableDir;
    }

    Configuration getConf() {
        return this.conf;
    }

    public int merge() throws IOException {
        return this.mergeWithCache(this.cacheReference.deref());
    }

    int mergeWithCache(Cache cache) throws IOException {
        List<Mergee> mergeContenders = this.getMergeContenders(cache.getCachePaths(CacheReference.CacheUpdate.PathType.MUTABLE));
        MergeDecider.MergeDecision mergeDecision = this.getMerges(mergeContenders);
        this.moveToStable(mergeDecision.getTooLargeToMerge());
        return this.mergeAndDelete(this.compactsDir, this.compactsDir, mergeDecision.getMerges(), CacheReference.CacheUpdate.PathType.MUTABLE);
    }

    private void moveToStable(List<Mergee> tooLargeToMerge) throws IOException {
        ArrayList<Set<Mergee>> mergees = new ArrayList<Set<Mergee>>();
        for (Mergee m : tooLargeToMerge) {
            mergees.add(new HashSet<Mergee>(Arrays.asList(m)));
        }
        this.mergeAndDelete(this.compactsDir, this.stableDir, mergees, CacheReference.CacheUpdate.PathType.STABLE);
    }

    private List<Mergee> getMergeContenders(Set<String> compactionPaths) throws IOException {
        ArrayList<Mergee> unsortedMergees = new ArrayList<Mergee>();
        for (String compactionPath : compactionPaths) {
            Path path = new Path(compactionPath);
            try {
                long compactionSize = this.fs.getContentSummary(path).getLength();
                unsortedMergees.add(new Mergee(compactionSize, path));
            }
            catch (FileNotFoundException e) {
                gLogger.warn((Object)("Compaction path did not exist. Ignoring path from merge: " + path));
            }
        }
        return unsortedMergees;
    }

    private MergeDecider.MergeDecision getMerges(List<Mergee> unsortedMergees) {
        return MergeDecider.create(this.conf).getMerges(new MergeeTree((Collection<Mergee>)unsortedMergees));
    }

    private int mergeAndDelete(Path fromDir, Path toDir, List<Set<Mergee>> merges, CacheReference.CacheUpdate.PathType pathType) {
        Path resultDir = toDir == null ? null : MapCache.getUniquePath(toDir);
        int mergeCount = 0;
        Merger merger = new Merger(this.fs, this.cacheReference, resultDir, pathType);
        for (Set<Mergee> merge : merges) {
            try {
                boolean merged = merger.merge(merge);
                if (!merged) continue;
                ++mergeCount;
                new MergeDeleter(this.fs, fromDir).delete(merge);
            }
            catch (Exception e) {
                gLogger.warn((Object)("Got exception when merging: " + e.getClass() + ":\"" + e.getMessage() + "\". Ignoring for now"));
            }
        }
        return mergeCount;
    }

    public void deletePaths(Set<String> cachePaths) {
        HashSet<Mergee> stablesToDelete = new HashSet<Mergee>();
        HashSet<Mergee> mutablesToDelete = new HashSet<Mergee>();
        for (String s : cachePaths) {
            if (this.isStable(s)) {
                stablesToDelete.add(new Mergee(0L, new Path(s)));
                continue;
            }
            if (this.isMutable(s)) {
                mutablesToDelete.add(new Mergee(0L, new Path(s)));
                continue;
            }
            gLogger.debug((Object)("Not deleting cache path: " + s + ", since it was neither stable nor mutable"));
        }
        this.deleteMergees(stablesToDelete, this.stableDir);
        this.deleteMergees(mutablesToDelete, this.compactsDir);
    }

    private void deleteMergees(Set<Mergee> mergeesToDelete, Path baseDir) {
        if (!mergeesToDelete.isEmpty()) {
            this.mergeAndDelete(baseDir, null, Arrays.asList(mergeesToDelete), CacheReference.CacheUpdate.PathType.DELETE);
        }
    }

    private boolean isStable(String path) {
        return path.startsWith(this.stableDir.toUri().getPath());
    }

    private boolean isMutable(String path) {
        return path.startsWith(this.compactsDir.toUri().getPath());
    }

    public static class Mergee {
        public final long size;
        public final Path path;

        public Mergee(long size, Path path) {
            this.size = size;
            this.path = path;
        }

        public String toString() {
            return "Mergee [size=" + this.size + ", path=" + this.path + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mergee other = (Mergee)obj;
            if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
                return false;
            }
            return this.size == other.size;
        }
    }
}

