/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.queues.CloseableBlockingQueue;
import com.splunk.mr.cache.reader.CachedResultProcessor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class GroupedProcessor<K, V> {
    public static final int ERROR_LIMIT = 5;
    private static final Logger gLogger = Logger.getLogger(CachedResultProcessor.class);
    private final ConcurrentLinkedQueue<Future<?>> futures;
    private final ExecutorService processThreadPool;
    private final ProcessFactory<K, V> factory;
    private final Map<K, CloseableBlockingQueue<V>> queues = new ConcurrentHashMap<K, CloseableBlockingQueue<V>>();
    private final CloseableQueueProvider<V> queueProvider;
    private boolean hasAwaitedCompletion;

    public GroupedProcessor(ProcessFactory<K, V> factory, ExecutorService fetcherThreadPool) {
        this(factory, fetcherThreadPool, new CloseableQueueProvider<V>(){

            @Override
            public CloseableBlockingQueue<V> getNew() {
                return CloseableBlockingQueue.create();
            }
        });
    }

    public GroupedProcessor(ProcessFactory<K, V> factory, ExecutorService fetcherThreadPool, CloseableQueueProvider<V> queueProvider) {
        this.factory = factory;
        this.queueProvider = queueProvider;
        this.processThreadPool = fetcherThreadPool;
        this.futures = new ConcurrentLinkedQueue();
        this.hasAwaitedCompletion = false;
    }

    public void offer(K key, V value) {
        if (this.hasAwaitedCompletion) {
            throw new IllegalStateException();
        }
        if (!this.queues.containsKey(key)) {
            this.putNewQueueToWork(this.queues, key, value);
        } else {
            this.putValueInQueue(this.queues.get(key), value);
        }
    }

    private void putNewQueueToWork(Map<K, CloseableBlockingQueue<V>> queues, K key, V value) {
        CloseableBlockingQueue<V> queue = this.queueProvider.getNew();
        Processor<V> processor = this.factory.getNew(key, this);
        queues.put(key, queue);
        this.putValueInQueue(queue, value);
        this.putProcessorInPool(processor, queue, 0);
    }

    private void putProcessorInPool(Processor<V> processor, CloseableBlockingQueue<V> queue, int errors) {
        this.futures.add(this.processThreadPool.submit(new ProcessAllQueuedValues(processor, queue, errors)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putValueInQueue(CloseableBlockingQueue<V> queue, V value) {
        CloseableBlockingQueue<V> closeableBlockingQueue = queue;
        synchronized (closeableBlockingQueue) {
            queue.offer(value);
        }
    }

    public void awaitCompletion() {
        this.hasAwaitedCompletion = true;
        gLogger.debug((Object)("waiting for " + this.futures.size() + " cache fetchers to join.."));
        while (!this.futures.isEmpty()) {
            this.join(this.futures.poll());
        }
        gLogger.debug((Object)"done waiting for cache fetchers to join!");
    }

    private void join(Future<?> f) {
        try {
            f.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ProcessAllQueuedValues
    implements Runnable {
        private final Processor<V> processor;
        private final CloseableBlockingQueue<V> queue;
        private int errors;

        public ProcessAllQueuedValues(Processor<V> processor, CloseableBlockingQueue<V> queue, int errors) {
            this.processor = processor;
            this.queue = queue;
            this.errors = Math.min(5, errors);
        }

        @Override
        public void run() {
            try {
                this.processor.init();
                this.fetchAllItemsFromQueue();
            }
            catch (Exception e) {
                ++this.errors;
                gLogger.debug((Object)("Got exception when processing queue: " + e + ". " + this.getErrorCountString()));
            }
            finally {
                this.setupProcessorRetry();
            }
        }

        private String getErrorCountString() {
            return this.errors >= 5 ? "Hit error limit: 5" : "Error #" + this.errors;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void fetchAllItemsFromQueue() throws InterruptedException {
            try {
                Object value;
                while (this.queue.hasNext() && (value = this.queue.take()) != null) {
                    try {
                        if (this.errors >= 5) {
                            throw new RetryLimitHitException();
                        }
                        this.processor.process(value);
                    }
                    catch (RuntimeException e) {
                        this.processor.processFailure(value);
                        throw e;
                        return;
                    }
                }
            }
            finally {
                this.processor.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setupProcessorRetry() {
            CloseableBlockingQueue closeableBlockingQueue = this.queue;
            synchronized (closeableBlockingQueue) {
                if (!this.queue.isFinished()) {
                    if (this.queue.hasNext()) {
                        GroupedProcessor.this.putProcessorInPool(this.processor, this.queue, this.errors);
                    } else {
                        this.queue.setNewItemListener(new Runnable(){

                            @Override
                            public void run() {
                                GroupedProcessor.this.putProcessorInPool(ProcessAllQueuedValues.this.processor, ProcessAllQueuedValues.this.queue, ProcessAllQueuedValues.this.errors);
                            }
                        });
                    }
                }
            }
        }
    }

    public static interface CloseableQueueProvider<V> {
        public CloseableBlockingQueue<V> getNew();
    }

    public static interface ProcessFactory<K, V> {
        public Processor<V> getNew(K var1, GroupedProcessor<K, V> var2);
    }

    public static abstract class Processor<V> {
        private static final Logger gLogger = Logger.getLogger(Processor.class);

        public void init() throws IOException {
        }

        public abstract void process(V var1);

        public void reset() {
        }

        public void processFailure(V v) {
            gLogger.debug((Object)("Processing failure: " + v.toString()));
        }
    }

    public static class RetryLimitHitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

