/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.reader;

import com.splunk.mr.cache.Cache;
import com.splunk.mr.cache.CacheIndexer;
import com.splunk.mr.cache.CacheReference;
import com.splunk.mr.cache.PathAndPointer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MD5Hash;
import org.apache.log4j.Logger;

public class CachePathsReader {
    private static final Logger gLogger = Logger.getLogger(CachePathsReader.class);
    private final FileSystem fs;
    private final CacheReference cacheReference;
    private final Map<MD5Hash, PathAndPointer> cachePaths;
    private final Set<String> readPaths;
    private volatile ExecutorService threadPool;
    private volatile Cache currentCache;

    public CachePathsReader(FileSystem fs, CacheReference cacheReference, Map<MD5Hash, PathAndPointer> keys) {
        this.fs = fs;
        this.cacheReference = cacheReference;
        this.cachePaths = keys;
        this.readPaths = new HashSet<String>();
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public synchronized Map<MD5Hash, PathAndPointer> readCachePaths() {
        this.getCurrentCache();
        return this.cachePaths;
    }

    private void readNewKeys(Cache cache) {
        if (!this.readPaths.containsAll(cache.getCachePaths())) {
            try {
                this.doReadNewKeys(cache);
            }
            catch (IOException e) {
                this.retryIfNewCacheIsAcquired(e);
            }
        }
    }

    private void getAllFutures(List<Future<?>> futures) {
        for (Future<?> f : futures) {
            try {
                f.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (KeysReadException e) {
                this.retryIfNewCacheIsAcquired(e);
            }
        }
    }

    private synchronized void doReadNewKeys(Cache cache) throws IOException {
        if (this.threadPool != null) {
            this.doReadWithThreadPool(cache, this.threadPool);
        } else {
            ExecutorService singleThreadedPool = Executors.newFixedThreadPool(1);
            try {
                this.doReadWithThreadPool(cache, singleThreadedPool);
            }
            finally {
                singleThreadedPool.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadWithThreadPool(Cache cache, ExecutorService threadPool) {
        ArrayList futures = new ArrayList();
        try {
            for (final String p : cache.getCachePaths()) {
                if (this.readPaths.contains(p)) continue;
                futures.add(threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        Map<MD5Hash, CacheIndexer.ResultPointer> keys;
                        try {
                            keys = CacheIndexer.getKeys(CachePathsReader.this.fs, new Path(p));
                        }
                        catch (IOException e) {
                            throw new KeysReadException();
                        }
                        HashMap<MD5Hash, PathAndPointer> newKeys = new HashMap<MD5Hash, PathAndPointer>();
                        for (Map.Entry<MD5Hash, CacheIndexer.ResultPointer> key : keys.entrySet()) {
                            newKeys.put(key.getKey(), new PathAndPointer(p, key.getValue()));
                        }
                        CachePathsReader.this.cachePaths.putAll(newKeys);
                        CachePathsReader.this.readPaths.add(p);
                    }
                }));
            }
        }
        finally {
            this.getAllFutures(futures);
        }
    }

    private void retryIfNewCacheIsAcquired(Exception e) {
        Cache newCache = this.getNewCache();
        if (this.currentCache.getId() == newCache.getId()) {
            gLogger.debug((Object)"Cache was up to date. Will stop retrying to read the cache");
            throw new RuntimeException(e);
        }
        this.currentCache = newCache;
        gLogger.debug((Object)"Got new cache! Will retry reading keys");
        this.readNewKeys(this.currentCache);
    }

    private Cache getNewCache() {
        try {
            return this.cacheReference.deref();
        }
        catch (IOException e) {
            this.logCacheDereferenceError(e);
            return this.currentCache;
        }
    }

    private Cache getCurrentCache() {
        if (this.currentCache == null) {
            this.updateCacheRef();
        }
        return this.currentCache;
    }

    public void updateCacheRef() {
        try {
            this.currentCache = this.cacheReference.deref();
            this.readNewKeys(this.currentCache);
        }
        catch (IOException e) {
            this.logCacheDereferenceError(e);
            throw new RuntimeException(e);
        }
    }

    private void logCacheDereferenceError(IOException e) {
        gLogger.error((Object)("Could not get the current state of the cache to read the keys: " + e.toString()));
    }

    public static CachePathsReader create(FileSystem fs, CacheReference cacheRef) {
        return new CachePathsReader(fs, cacheRef, new ConcurrentHashMap<MD5Hash, PathAndPointer>());
    }

    private static class KeysReadException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private KeysReadException() {
        }
    }
}

