/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import java.io.File;

public class ManifestLine {
    private final Type type;
    private final Integer mode;
    private final String user;
    private final String group;
    private final String path;
    private final File file;

    public ManifestLine(Type type, Integer mode, String user, String group, String path, File file) {
        this.type = type;
        this.mode = mode;
        this.user = user;
        this.group = group;
        this.path = path;
        this.file = file;
    }

    public Type getType() {
        return this.type;
    }

    public Integer getMode() {
        return this.mode;
    }

    public String getUser() {
        return this.user;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    public static enum Type {
        FILE("f"),
        DIR("d"),
        LINK("l"),
        COMMENT("#");

        private final String letter;

        private Type(String letter) {
            this.letter = letter;
        }

        public String getLetter() {
            return this.letter;
        }

        public static Type createByLetter(String letter) {
            char l = letter.toLowerCase().toCharArray()[0];
            switch (l) {
                case 'f': {
                    return FILE;
                }
                case 'd': {
                    return DIR;
                }
                case 'l': {
                    return LINK;
                }
                case '#': {
                    return COMMENT;
                }
            }
            throw new RuntimeException("Unknown manifest line type letter=" + letter);
        }
    }

    public static class CommentLine
    extends ManifestLine {
        public CommentLine() {
            super(Type.COMMENT, null, null, null, null, null);
        }
    }
}

