/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SynchronizedExecuter<T> {
    private static Logger gLogger = Logger.getLogger((String)"SynchronizedExecuter");

    public static AtomicFactory<File> createFileAtomically() {
        return new AtomicFactory<File>(){

            @Override
            public boolean create(File toCreate) {
                try {
                    return toCreate.createNewFile();
                }
                catch (IOException ignore) {
                    return false;
                }
            }
        };
    }

    public static AbortCondition ifInstalledExistsOrExceedsTimeLimit(final File installed, final long maxWait, final long startTime) {
        return new AbortCondition(){

            @Override
            public boolean shouldStopRetrying() {
                return installed.exists() || System.currentTimeMillis() - startTime > maxWait;
            }
        };
    }

    public void executeSynchronized(TempProvider<T> tempProvider, AcquiredHandler<T> acquiredHandler, AbortCondition abortCondition, AtomicFactory<T> creator, long millisSleepPerTry) {
        SynchronizedExecuter.executeOnAcquired(tempProvider, acquiredHandler, abortCondition, creator, millisSleepPerTry);
    }

    public static <T> void executeOnAcquired(TempProvider<T> tempProvider, AcquiredHandler<T> acquiredHandler, AbortCondition abortCondition, AtomicFactory<T> creator, long millisSleepPerTry) {
        while (!abortCondition.shouldStopRetrying()) {
            T temp = tempProvider.getTemp();
            if (creator.create(temp)) {
                acquiredHandler.onAcquired(temp);
                continue;
            }
            gLogger.info((Object)("Waiting for " + millisSleepPerTry + "seconds before trying again"));
            SynchronizedExecuter.sleep(millisSleepPerTry);
        }
    }

    private static void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static interface AtomicFactory<T> {
        public boolean create(T var1);
    }

    public static interface TempProvider<T> {
        public T getTemp();
    }

    public static interface AcquiredHandler<T> {
        public void onAcquired(T var1);
    }

    public static interface AbortCondition {
        public boolean shouldStopRetrying();
    }
}

