/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.nscache;

import com.splunk.mr.input.VirtualIndex;
import com.splunk.nscache.NSCache;
import com.splunk.sdk.SplunkMiniSDK;
import com.splunk.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;

public class CachedFileSystem
extends FileSystem {
    private static Logger gLogger = Logger.getLogger(CachedFileSystem.class);
    private FileSystem fs;
    private NSCache cache;
    private FileStatus rootStat;
    public static final String CONF_VIX_LEVEL_NSCACHE_PREFIX = "nscache";
    public static final String CONF_PROVIDER_LEVEL_NSCACHE_PREFIX = "splunk.search.nscache";
    public static final String CONF_PROVIDER_LEVEL_NSCACHE_ENABLED = "splunk.search.nscache";
    public static final String CONF_VIX_LEVEL_NSCACHE_ENABLED = "nscache";
    public static final String CONF_NSCACHE_TTL = "ttl";
    public static final String CONF_NSCACHE_COMPRESS = "compress";
    public static final String CONF_NSCACHE_MAX_SIZE = "max.size";
    public static final boolean DEFAULT_NSCACHE_ENABLED = false;

    public CachedFileSystem(FileSystem fs, FileStatus rootStat, String vixName, String inputId, boolean reapCache, long ttl, long maxSize, boolean compress) throws IOException {
        this.init(fs, vixName, rootStat, inputId, reapCache, ttl, maxSize, compress);
    }

    public CachedFileSystem(FileSystem fs, FileStatus rootStat, VirtualIndex vix, String inputId, boolean reapCache) throws IOException {
        long ttl = Long.parseLong(vix.getNSCacheConf(CONF_NSCACHE_TTL, Long.toString(28800000L)));
        long maxSize = Long.parseLong(vix.getNSCacheConf(CONF_NSCACHE_MAX_SIZE, Long.toString(0x6400000L)));
        boolean compress = StrUtil.parseBoolean(vix.getNSCacheConf(CONF_NSCACHE_COMPRESS, Boolean.toString(false)), false);
        this.init(fs, vix.getName(), rootStat, inputId, reapCache, ttl, maxSize, compress);
    }

    private void init(FileSystem fs, String vixName, FileStatus rootStat, String inputId, boolean reapCache, long ttl, long maxSize, boolean compress) throws IOException {
        this.fs = fs;
        this.rootStat = rootStat;
        this.cache = new NSCache(vixName, inputId, rootStat, ttl, maxSize, compress);
        if (reapCache && Math.random() < 0.1) {
            CacheReaper cr = new CacheReaper(fs.getConf());
            cr.start();
        }
        this.cache.load();
    }

    public void saveCache() {
        try {
            this.cache.save();
        }
        catch (Exception e) {
            gLogger.warn((Object)("Failed to save nscache. cache=" + this.cache), (Throwable)e);
            this.cache.delete();
        }
    }

    public boolean isCacheExpired() {
        return this.cache.isExpired();
    }

    public Path getCacheRootPath() {
        if (this.rootStat == null) {
            return null;
        }
        return this.rootStat.getPath();
    }

    public String toString() {
        return "CachedFileSystem: cache=" + String.valueOf(this.cache);
    }

    public FileStatus getFileStatus(Path p) throws IOException {
        FileStatus stat = null;
        if (this.cache.isExpired()) {
            stat = this.fs.getFileStatus(p);
            try {
                this.cache.addNode(stat);
            }
            catch (Exception e) {
                this.cache.delete();
            }
        } else {
            try {
                stat = this.cache.getFileStatus(p);
            }
            catch (Exception e) {
                this.cache.delete();
            }
        }
        return stat;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        FileStatus[] stats = null;
        if (this.cache.isExpired()) {
            stats = this.fs.listStatus(path);
            try {
                this.cache.addNodes(stats);
            }
            catch (Exception e) {
                this.cache.delete();
            }
        } else {
            try {
                stats = this.cache.listStatus(path);
            }
            catch (Exception e) {
                this.cache.delete();
            }
        }
        return stats;
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        FileStatus[] stats;
        if (this.cache.isExpired()) {
            stats = this.fs.globStatus(pathPattern, filter);
            try {
                this.cache.addNodes(stats);
            }
            catch (Exception e) {
                this.cache.delete();
            }
        } else {
            stats = super.globStatus(pathPattern, filter);
        }
        return stats;
    }

    public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
        return this.fs.append(arg0, arg1, arg2);
    }

    public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
        return this.fs.create(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public boolean delete(Path arg0) throws IOException {
        return this.fs.delete(arg0);
    }

    public boolean delete(Path arg0, boolean arg1) throws IOException {
        return this.fs.delete(arg0, arg1);
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public Path getWorkingDirectory() {
        return this.fs.getWorkingDirectory();
    }

    public boolean mkdirs(Path arg0, FsPermission arg1) throws IOException {
        return this.fs.mkdirs(arg0, arg1);
    }

    public FSDataInputStream open(Path arg0, int arg1) throws IOException {
        return this.fs.open(arg0, arg1);
    }

    public boolean rename(Path arg0, Path arg1) throws IOException {
        return this.fs.rename(arg0, arg1);
    }

    public void setWorkingDirectory(Path arg0) {
        this.fs.setWorkingDirectory(arg0);
    }

    public Configuration getConf() {
        return this.fs.getConf();
    }

    private class CacheReaper
    extends Thread {
        private Configuration conf;

        public CacheReaper(Configuration conf) {
            this.conf = conf;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                CacheReaper.yield();
                gLogger.info((Object)"Start reaping abandoned caches ...");
                long st = System.currentTimeMillis();
                File cacheDir = NSCache.getCacheDir();
                SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(this.conf);
                SplunkMiniSDK.SplunkResponse sr = sdk.get("/servicesNS/nobody/search/admin/indexes", new String[0]);
                if (sr.getStatusCode() != 200) {
                    throw new RuntimeException("Failed to call splunk endpoint services to get indexes conf. statusCode=" + sr.getStatusCode());
                }
                HashSet<String> cacheFileNamePrefixes = new HashSet<String>();
                for (JsonNode jn : sr.entries()) {
                    JsonNode content = jn.get("content");
                    if (!content.get("isVirtual").getBooleanValue()) continue;
                    String vixName = jn.get("name").getTextValue();
                    String cacheFileNamePrefix = NSCache.getCacheFileNamePrefix(vixName);
                    cacheFileNamePrefixes.add(cacheFileNamePrefix);
                }
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("Retrieved caches filename prefixes for all vix: " + cacheFileNamePrefixes));
                }
                for (String name : cacheDir.list()) {
                    if (cacheFileNamePrefixes.contains(name.split("_")[0])) continue;
                    File f = new File(cacheDir, name);
                    f.delete();
                    gLogger.info((Object)("Deleted a nscache " + f.getPath()));
                }
                gLogger.info((Object)("Done! Reaping abandoned caches took " + (System.currentTimeMillis() - st) + " ms."));
            }
            catch (Exception e) {
                String msg = "Failed to reap nscache=" + CachedFileSystem.this.cache;
                if (gLogger.isDebugEnabled()) {
                    gLogger.warn((Object)msg, (Throwable)e);
                }
                gLogger.warn((Object)(msg + ": " + e.getMessage()));
            }
        }
    }
}

