/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.session;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.spark.HiveSparkClient;
import org.apache.hadoop.hive.ql.exec.spark.HiveSparkClientFactory;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobRef;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.spark.SparkConf;
import org.apache.spark.util.Utils;

public class SparkSessionImpl
implements SparkSession {
    private static final Log LOG = LogFactory.getLog(SparkSession.class);
    private HiveConf conf;
    private boolean isOpen;
    private final String sessionId = SparkSessionImpl.makeSessionId();
    private HiveSparkClient hiveSparkClient;

    @Override
    public void open(HiveConf conf) throws HiveException {
        this.conf = conf;
        this.isOpen = true;
        try {
            this.hiveSparkClient = HiveSparkClientFactory.createHiveSparkClient(conf);
        }
        catch (Exception e) {
            throw new HiveException("Failed to create spark client.", e);
        }
    }

    @Override
    public SparkJobRef submit(DriverContext driverContext, SparkWork sparkWork) throws Exception {
        Preconditions.checkState(this.isOpen, "Session is not open. Can't submit jobs.");
        return this.hiveSparkClient.execute(driverContext, sparkWork);
    }

    @Override
    public ObjectPair<Long, Integer> getMemoryAndCores() throws Exception {
        int totalCores;
        SparkConf sparkConf = this.hiveSparkClient.getSparkConf();
        int numExecutors = this.hiveSparkClient.getExecutorCount();
        if (numExecutors <= 0) {
            return new ObjectPair<Long, Integer>(-1L, -1);
        }
        int executorMemoryInMB = Utils.memoryStringToMb((String)sparkConf.get("spark.executor.memory", "512m"));
        double memoryFraction = 1.0 - sparkConf.getDouble("spark.storage.memoryFraction", 0.6);
        long totalMemory = (long)((double)(numExecutors * executorMemoryInMB) * memoryFraction * 1024.0 * 1024.0);
        String masterURL = sparkConf.get("spark.master");
        if (masterURL.startsWith("spark")) {
            totalCores = sparkConf.contains("spark.default.parallelism") ? sparkConf.getInt("spark.default.parallelism", 1) : this.hiveSparkClient.getDefaultParallelism();
            totalCores = Math.max(totalCores, numExecutors);
        } else {
            int coresPerExecutor = sparkConf.getInt("spark.executor.cores", 1);
            totalCores = numExecutors * coresPerExecutor;
        }
        long memoryPerTaskInBytes = totalMemory / (long)(totalCores /= sparkConf.getInt("spark.task.cpus", 1));
        LOG.info((Object)("Spark cluster current has executors: " + numExecutors + ", total cores: " + totalCores + ", memory per executor: " + executorMemoryInMB + "M, memoryFraction: " + memoryFraction));
        return new ObjectPair<Long, Integer>(memoryPerTaskInBytes, totalCores);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public HiveConf getConf() {
        return this.conf;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void close() {
        this.isOpen = false;
        if (this.hiveSparkClient != null) {
            try {
                this.hiveSparkClient.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to close spark session (" + this.sessionId + ")."), (Throwable)e);
            }
        }
        this.hiveSparkClient = null;
    }

    public static String makeSessionId() {
        return UUID.randomUUID().toString();
    }
}

