/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastKeyStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.BytesWritable;

public abstract class VectorMapJoinFastBytesHashTable
extends VectorMapJoinFastHashTable
implements VectorMapJoinBytesHashTable {
    private static final Log LOG = LogFactory.getLog(VectorMapJoinFastBytesHashTable.class);
    protected VectorMapJoinFastKeyStore keyStore;
    private BytesWritable testKeyBytesWritable;
    private BytesWritable testValueBytesWritable;
    protected long[] slotTriples;

    @Override
    public void putRow(BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.add(keyBytes, 0, keyLength, currentValue);
    }

    @VisibleForTesting
    public void putRow(byte[] currentKey, byte[] currentValue) throws HiveException, IOException {
        if (this.testKeyBytesWritable == null) {
            this.testKeyBytesWritable = new BytesWritable();
            this.testValueBytesWritable = new BytesWritable();
        }
        this.testKeyBytesWritable.set(currentKey, 0, currentKey.length);
        this.testValueBytesWritable.set(currentValue, 0, currentValue.length);
        this.putRow(this.testKeyBytesWritable, this.testValueBytesWritable);
    }

    protected abstract void assignSlot(int var1, byte[] var2, int var3, int var4, long var5, boolean var7, BytesWritable var8);

    public void add(byte[] keyBytes, int keyStart, int keyLength, BytesWritable currentValue) {
        boolean isNewKey;
        if (this.resizeThreshold <= this.keysAssigned) {
            this.expandAndRehash();
        }
        long hashCode = VectorMapJoinFastBytesHashUtil.hashKey(keyBytes, keyStart, keyLength);
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        while (true) {
            int tripleIndex;
            if (this.slotTriples[tripleIndex = 3 * slot] == 0L) {
                isNewKey = true;
                break;
            }
            if (hashCode == this.slotTriples[tripleIndex + 1] && this.keyStore.equalKey(this.slotTriples[tripleIndex], keyBytes, keyStart, keyLength)) {
                isNewKey = false;
                break;
            }
            ++this.metricPutConflict;
            slot = (int)((probeSlot += (long)(++i)) & (long)this.logicalHashBucketMask);
        }
        if (this.largestNumberOfSteps < i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Probed " + i + " slots (the longest so far) to find space"));
            }
            this.largestNumberOfSteps = i;
        }
        this.assignSlot(slot, keyBytes, keyStart, keyLength, hashCode, isNewKey, currentValue);
        if (isNewKey) {
            ++this.keysAssigned;
        }
    }

    private void expandAndRehash() {
        int newLogicalHashBucketCount = this.logicalHashBucketCount * 2;
        int newLogicalHashBucketMask = newLogicalHashBucketCount - 1;
        int newMetricPutConflict = 0;
        int newLargestNumberOfSteps = 0;
        int newSlotTripleArraySize = newLogicalHashBucketCount * 3;
        long[] newSlotTriples = new long[newSlotTripleArraySize];
        for (int slot = 0; slot < this.logicalHashBucketCount; ++slot) {
            int newTripleIndex;
            long newKeyRef;
            int tripleIndex = slot * 3;
            long keyRef = this.slotTriples[tripleIndex];
            if (keyRef == 0L) continue;
            long hashCode = this.slotTriples[tripleIndex + 1];
            long valueRef = this.slotTriples[tripleIndex + 2];
            int intHashCode = (int)hashCode;
            int newSlot = intHashCode & newLogicalHashBucketMask;
            long newProbeSlot = newSlot;
            int i = 0;
            while ((newKeyRef = newSlotTriples[newTripleIndex = newSlot * 3]) != 0L) {
                ++newMetricPutConflict;
                newSlot = (int)((newProbeSlot += (long)(++i)) & (long)newLogicalHashBucketMask);
            }
            if (newLargestNumberOfSteps < i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Probed " + i + " slots (the longest so far) to find space"));
                }
                newLargestNumberOfSteps = i;
            }
            newSlotTriples[newTripleIndex] = keyRef;
            newSlotTriples[newTripleIndex + 1] = hashCode;
            newSlotTriples[newTripleIndex + 2] = valueRef;
        }
        this.slotTriples = newSlotTriples;
        this.logicalHashBucketCount = newLogicalHashBucketCount;
        this.logicalHashBucketMask = newLogicalHashBucketMask;
        this.metricPutConflict = newMetricPutConflict;
        this.largestNumberOfSteps = newLargestNumberOfSteps;
        this.resizeThreshold = (int)((float)this.logicalHashBucketCount * this.loadFactor);
        ++this.metricExpands;
    }

    protected long findReadSlot(byte[] keyBytes, int keyStart, int keyLength, long hashCode) {
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        int tripleIndex;
        while (this.slotTriples[tripleIndex = slot * 3] == 0L || hashCode != this.slotTriples[tripleIndex + 1] || !this.keyStore.equalKey(this.slotTriples[tripleIndex], keyBytes, keyStart, keyLength)) {
            probeSlot += (long)(++i);
            if (i > this.largestNumberOfSteps) {
                return -1L;
            }
            slot = (int)(probeSlot & (long)this.logicalHashBucketMask);
        }
        return this.slotTriples[tripleIndex + 2];
    }

    private void allocateBucketArray() {
        int slotTripleArraySize = 3 * this.logicalHashBucketCount;
        this.slotTriples = new long[slotTripleArraySize];
    }

    public VectorMapJoinFastBytesHashTable(int initialCapacity, float loadFactor, int writeBuffersSize) {
        super(initialCapacity, loadFactor, writeBuffersSize);
        this.allocateBucketArray();
    }
}

