/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.RunLengthByteReader;

class BitFieldReader {
    private final RunLengthByteReader input;
    private final int bitSize;
    private int current;
    private int bitsLeft;
    private final int mask;

    BitFieldReader(InStream input, int bitSize) throws IOException {
        this.input = new RunLengthByteReader(input);
        this.bitSize = bitSize;
        this.mask = (1 << bitSize) - 1;
    }

    private void readByte() throws IOException {
        if (!this.input.hasNext()) {
            throw new EOFException("Read past end of bit field from " + this);
        }
        this.current = 0xFF & this.input.next();
        this.bitsLeft = 8;
    }

    int next() throws IOException {
        int bitsLeftToRead;
        int result = 0;
        for (bitsLeftToRead = this.bitSize; bitsLeftToRead > this.bitsLeft; bitsLeftToRead -= this.bitsLeft) {
            result <<= this.bitsLeft;
            result |= this.current & (1 << this.bitsLeft) - 1;
            this.readByte();
        }
        if (bitsLeftToRead > 0) {
            result <<= bitsLeftToRead;
            this.bitsLeft -= bitsLeftToRead;
            result |= this.current >>> this.bitsLeft & (1 << bitsLeftToRead) - 1;
        }
        return result & this.mask;
    }

    void nextVector(LongColumnVector previous, long previousLen) throws IOException {
        previous.isRepeating = true;
        int i = 0;
        while ((long)i < previousLen) {
            previous.vector[i] = !previous.isNull[i] ? (long)this.next() : 1L;
            if (previous.isRepeating && i > 0 && (previous.vector[i - 1] != previous.vector[i] || previous.isNull[i - 1] != previous.isNull[i])) {
                previous.isRepeating = false;
            }
            ++i;
        }
    }

    void seek(PositionProvider index) throws IOException {
        this.input.seek(index);
        int consumed = (int)index.getNext();
        if (consumed > 8) {
            throw new IllegalArgumentException("Seek past end of byte at " + consumed + " in " + this.input);
        }
        if (consumed != 0) {
            this.readByte();
            this.bitsLeft = 8 - consumed;
        } else {
            this.bitsLeft = 0;
        }
    }

    void skip(long items) throws IOException {
        long totalBits = (long)this.bitSize * items;
        if ((long)this.bitsLeft >= totalBits) {
            this.bitsLeft = (int)((long)this.bitsLeft - totalBits);
        } else {
            this.input.skip((totalBits -= (long)this.bitsLeft) / 8L);
            this.current = this.input.next();
            this.bitsLeft = (int)(8L - totalBits % 8L);
        }
    }

    public String toString() {
        return "bit reader current: " + this.current + " bits left: " + this.bitsLeft + " bit size: " + this.bitSize + " from " + this.input;
    }
}

