/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.IOUtils;

public class OperationLog {
    private static final Log LOG = LogFactory.getLog((String)OperationLog.class.getName());
    private final String operationName;
    private final LogFile logFile;
    private LoggingLevel opLoggingLevel = LoggingLevel.UNKNOWN;
    private static final ThreadLocal<OperationLog> THREAD_LOCAL_OPERATION_LOG = new ThreadLocal<OperationLog>(){

        @Override
        protected synchronized OperationLog initialValue() {
            return null;
        }
    };

    public OperationLog(String name, File file, HiveConf hiveConf) throws FileNotFoundException {
        this.operationName = name;
        this.logFile = new LogFile(file);
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            String logLevel = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL);
            this.opLoggingLevel = OperationLog.getLoggingLevel(logLevel);
        }
    }

    public static LoggingLevel getLoggingLevel(String mode) {
        if (mode.equalsIgnoreCase("none")) {
            return LoggingLevel.NONE;
        }
        if (mode.equalsIgnoreCase("execution")) {
            return LoggingLevel.EXECUTION;
        }
        if (mode.equalsIgnoreCase("verbose")) {
            return LoggingLevel.VERBOSE;
        }
        if (mode.equalsIgnoreCase("performance")) {
            return LoggingLevel.PERFORMANCE;
        }
        return LoggingLevel.UNKNOWN;
    }

    public LoggingLevel getOpLoggingLevel() {
        return this.opLoggingLevel;
    }

    public static void setCurrentOperationLog(OperationLog operationLog) {
        THREAD_LOCAL_OPERATION_LOG.set(operationLog);
    }

    public static OperationLog getCurrentOperationLog() {
        return THREAD_LOCAL_OPERATION_LOG.get();
    }

    public static void removeCurrentOperationLog() {
        THREAD_LOCAL_OPERATION_LOG.remove();
    }

    public void writeOperationLog(String operationLogMessage) {
        this.logFile.write(operationLogMessage);
    }

    public List<String> readOperationLog(boolean isFetchFirst, long maxRows) throws SQLException {
        return this.logFile.read(isFetchFirst, maxRows);
    }

    public void close() {
        this.logFile.remove();
    }

    private class LogFile {
        private File file;
        private BufferedReader in;
        private PrintStream out;
        private volatile boolean isRemoved;

        LogFile(File file) throws FileNotFoundException {
            this.file = file;
            this.in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            this.out = new PrintStream(new FileOutputStream(file));
            this.isRemoved = false;
        }

        synchronized void write(String msg) {
            this.out.print(msg);
        }

        synchronized List<String> read(boolean isFetchFirst, long maxRows) throws SQLException {
            if (isFetchFirst) {
                this.resetIn();
            }
            return this.readResults(maxRows);
        }

        void remove() {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                FileUtils.forceDelete((File)this.file);
                this.isRemoved = true;
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to remove corresponding log file of operation: " + OperationLog.this.operationName), (Throwable)e);
            }
        }

        private void resetIn() {
            if (this.in != null) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.in});
                this.in = null;
            }
        }

        private List<String> readResults(long nLines) throws SQLException {
            if (this.in == null) {
                try {
                    this.in = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
                }
                catch (FileNotFoundException e) {
                    if (this.isRemoved) {
                        throw new SQLException("The operation has been closed and its log file " + this.file.getAbsolutePath() + " has been removed.", e);
                    }
                    throw new SQLException("Operation Log file " + this.file.getAbsolutePath() + " is not found.", e);
                }
            }
            ArrayList<String> logs = new ArrayList<String>();
            String line = "";
            int i = 0;
            while ((long)i < nLines || nLines <= 0L) {
                try {
                    line = this.in.readLine();
                    if (line == null) break;
                    logs.add(line);
                }
                catch (IOException e) {
                    if (this.isRemoved) {
                        throw new SQLException("The operation has been closed and its log file " + this.file.getAbsolutePath() + " has been removed.", e);
                    }
                    throw new SQLException("Reading operation log file encountered an exception: ", e);
                }
                ++i;
            }
            return logs;
        }
    }

    public static enum LoggingLevel {
        NONE,
        EXECUTION,
        PERFORMANCE,
        VERBOSE,
        UNKNOWN;

    }
}

