/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCeilDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCeilDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCeilLongToLong;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloorCeilBase;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="ceil,ceiling", value="_FUNC_(x) - Find the smallest integer not smaller than x", extended="Example:\n  > SELECT _FUNC_(-0.1) FROM src LIMIT 1;\n  0\n  > SELECT _FUNC_(5) FROM src LIMIT 1;\n  5")
@VectorizedExpressions(value={FuncCeilLongToLong.class, FuncCeilDoubleToLong.class, FuncCeilDecimalToDecimal.class})
public final class GenericUDFCeil
extends GenericUDFFloorCeilBase {
    public GenericUDFCeil() {
        this.opDisplayName = "ceil";
    }

    @Override
    protected LongWritable evaluate(DoubleWritable input) {
        this.longWritable.set((long)Math.ceil(input.get()));
        return this.longWritable;
    }

    @Override
    protected HiveDecimalWritable evaluate(HiveDecimalWritable input) {
        HiveDecimal bd = input.getHiveDecimal();
        this.decimalWritable.set(bd.setScale(0, 2));
        return this.decimalWritable;
    }
}

