/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.util.Collection;
import java.util.List;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManagerBean;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArrayConverter
implements TypeConverter<double[]> {
    protected final TypeConverterManagerBean typeConverterManagerBean;

    public DoubleArrayConverter(TypeConverterManagerBean typeConverterManagerBean) {
        this.typeConverterManagerBean = typeConverterManagerBean;
    }

    @Override
    public double[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected double convertType(Object value) {
        return this.typeConverterManagerBean.convertType(value, Double.TYPE);
    }

    protected double[] convertToSingleElementArray(Object value) {
        return new double[]{this.convertType(value)};
    }

    protected double[] convertValueToArray(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            double[] target = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                target[i] = this.convertType(element);
            }
            return target;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            double[] target = new double[collection.size()];
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            int count = 0;
            for (Object element : iterable) {
                ++count;
            }
            double[] target = new double[count];
            int i = 0;
            for (Object element : iterable) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof CharSequence) {
            String[] strings = CsvUtil.toStringArray(value.toString());
            return this.convertArrayToArray(strings);
        }
        return this.convertToSingleElementArray(value);
    }

    protected double[] convertArrayToArray(Object value) {
        double[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType == Double.TYPE) {
            return (double[])value;
        }
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected double[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        double[] result;
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    result = null;
                                    if (primitiveComponentType == double[].class) {
                                        return (double[])value;
                                    }
                                    if (primitiveComponentType != Integer.TYPE) break block8;
                                    int[] array = (int[])value;
                                    result = new double[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = array[i];
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Long.TYPE) break block10;
                                long[] array = (long[])value;
                                result = new double[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = array[i];
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Float.TYPE) break block11;
                            float[] array = (float[])value;
                            result = new double[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = array[i];
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Short.TYPE) break block12;
                        short[] array = (short[])value;
                        result = new double[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = array[i];
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Byte.TYPE) break block13;
                    byte[] array = (byte[])value;
                    result = new double[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = array[i];
                    }
                    break block9;
                }
                if (primitiveComponentType != Character.TYPE) break block14;
                char[] array = (char[])value;
                result = new double[array.length];
                for (int i = 0; i < array.length; ++i) {
                    result[i] = array[i];
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] ? 1.0 : 0.0;
            }
        }
        return result;
    }
}

