/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.security.LlapSigner;
import org.apache.tez.common.ProtoConverters;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.EventProtos;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;

public class NotTezEventHelper {
    public static LlapSigner.Signable createSignableNotTezEvent(InputDataInformationEvent event, String vertexName, String destInputName) {
        final LlapDaemonProtocolProtos.NotTezEvent.Builder builder = LlapDaemonProtocolProtos.NotTezEvent.newBuilder().setInputEventProtoBytes(ProtoConverters.convertRootInputDataInformationEventToProto((InputDataInformationEvent)event).toByteString()).setVertexName(vertexName).setDestInputName(destInputName);
        return new LlapSigner.Signable(){

            @Override
            public void setSignInfo(int masterKeyId) {
                builder.setKeyId(masterKeyId);
            }

            @Override
            public byte[] serialize() throws IOException {
                LlapDaemonProtocolProtos.NotTezEvent nte = builder.build();
                ByteArrayOutputStream baos = new ByteArrayOutputStream(nte.getSerializedSize());
                nte.writeTo(baos);
                return baos.toByteArray();
            }
        };
    }

    public static TezEvent toTezEvent(LlapDaemonProtocolProtos.NotTezEvent nte) throws InvalidProtocolBufferException {
        EventMetaData sourceMetaData = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, nte.getVertexName(), "NULL_VERTEX", null);
        EventMetaData destMetaData = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, nte.getVertexName(), nte.getDestInputName(), null);
        InputDataInformationEvent event = ProtoConverters.convertRootInputDataInformationEventFromProto((EventProtos.RootInputDataInformationEventProto)EventProtos.RootInputDataInformationEventProto.parseFrom((ByteString)nte.getInputEventProtoBytes()));
        TezEvent tezEvent = new TezEvent((Event)event, sourceMetaData, System.currentTimeMillis());
        tezEvent.setDestinationInfo(destMetaData);
        return tezEvent;
    }
}

