/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.helpers;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.protocol.LlapTaskUmbilicalProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapTaskUmbilicalServer {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTaskUmbilicalServer.class);
    protected volatile Server server;
    private final InetSocketAddress address;
    private final AtomicBoolean started = new AtomicBoolean(true);
    private JobTokenSecretManager jobTokenSecretManager;
    private Map<String, int[]> tokenRefMap = new HashMap<String, int[]>();

    public LlapTaskUmbilicalServer(Configuration conf, LlapTaskUmbilicalProtocol umbilical, int numHandlers) throws IOException {
        this.jobTokenSecretManager = new JobTokenSecretManager();
        this.server = new RPC.Builder(conf).setProtocol(LlapTaskUmbilicalProtocol.class).setBindAddress("0.0.0.0").setPort(0).setInstance((Object)umbilical).setNumHandlers(numHandlers).setSecretManager((SecretManager)this.jobTokenSecretManager).build();
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(conf, (PolicyProvider)new LlapUmbilicalExternalPolicyProvider());
        }
        this.server.start();
        this.address = NetUtils.getConnectAddress((Server)this.server);
        LOG.info("Started TaskUmbilicalServer: " + umbilical.getClass().getName() + " at address: " + this.address + " with numHandlers=" + numHandlers);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getNumOpenConnections() {
        return this.server.getNumOpenConnections();
    }

    public synchronized void addTokenForJob(String tokenIdentifier, Token<JobTokenIdentifier> token) {
        int[] refCount = this.tokenRefMap.get(tokenIdentifier);
        if (refCount == null) {
            refCount = new int[]{0};
            this.tokenRefMap.put(tokenIdentifier, refCount);
            this.jobTokenSecretManager.addTokenForJob(tokenIdentifier, token);
        }
        refCount[0] = refCount[0] + 1;
    }

    public synchronized void removeTokenForJob(String tokenIdentifier) {
        int[] refCount = this.tokenRefMap.get(tokenIdentifier);
        if (refCount == null) {
            LOG.warn("No refCount found for tokenIdentifier " + tokenIdentifier);
        } else {
            refCount[0] = refCount[0] - 1;
            if (refCount[0] <= 0) {
                this.tokenRefMap.remove(tokenIdentifier);
                this.jobTokenSecretManager.removeTokenForJob(tokenIdentifier);
            }
        }
    }

    public void shutdownServer() {
        if (this.started.get()) {
            this.started.set(false);
            this.server.stop();
        }
    }

    public static class LlapUmbilicalExternalPolicyProvider
    extends PolicyProvider {
        private static final Service[] services = new Service[]{new Service("security.job.task.protocol.acl", LlapTaskUmbilicalProtocol.class)};

        public Service[] getServices() {
            return (Service[])services.clone();
        }
    }
}

