/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafFilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LeafFilterFactory.class);

    public FilterPredicateLeafBuilder getLeafFilterBuilderByType(PredicateLeaf.Type type, Type parquetType) throws HiveException {
        switch (type) {
            case LONG: {
                if (parquetType.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
                    return new IntFilterPredicateLeafBuilder();
                }
                return new LongFilterPredicateLeafBuilder();
            }
            case FLOAT: {
                if (parquetType.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FLOAT) {
                    return new FloatFilterPredicateLeafBuilder();
                }
                return new DoubleFilterPredicateLeafBuilder();
            }
            case STRING: {
                return new BinaryFilterPredicateLeafBuilder();
            }
            case BOOLEAN: {
                return new BooleanFilterPredicateLeafBuilder();
            }
        }
        String msg = "Conversion to Parquet FilterPredicate not supported for " + (Object)((Object)type);
        LOG.debug(msg);
        throw new HiveException(msg);
    }

    class BinaryFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        BinaryFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) throws Exception {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.binaryColumn(columnName), Binary.fromString((String)constant));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.binaryColumn(columnName), constant == null ? null : Binary.fromString((String)constant));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.binaryColumn(columnName), Binary.fromString((String)constant));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class BooleanFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        BooleanFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) throws Exception {
            switch (op) {
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.booleanColumn(columnName), constant == null ? null : Boolean.valueOf((Boolean)constant));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class DoubleFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        DoubleFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.doubleColumn(columnName), ((Number)constant).doubleValue());
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.doubleColumn(columnName), constant == null ? null : Double.valueOf(((Number)constant).doubleValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.doubleColumn(columnName), ((Number)constant).doubleValue());
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class FloatFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        FloatFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.floatColumn(columnName), Float.valueOf(((Number)constant).floatValue()));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.floatColumn(columnName), constant == null ? null : Float.valueOf(((Number)constant).floatValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.floatColumn(columnName), Float.valueOf(((Number)constant).floatValue()));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class LongFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        LongFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.longColumn(columnName), ((Number)constant).longValue());
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.longColumn(columnName), constant == null ? null : Long.valueOf(((Number)constant).longValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.longColumn(columnName), ((Number)constant).longValue());
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class IntFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        IntFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object literal, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.intColumn(columnName), ((Number)literal).intValue());
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.intColumn(columnName), literal == null ? null : Integer.valueOf(((Number)literal).intValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.intColumn(columnName), ((Number)literal).intValue());
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }
}

