/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.Stack;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class RuleExactMatch
implements Rule {
    private final String ruleName;
    private final String[] pattern;

    public RuleExactMatch(String ruleName, String[] pattern) {
        this.ruleName = ruleName;
        this.pattern = pattern;
    }

    @Override
    public int cost(Stack<Node> stack) throws SemanticException {
        int numElems;
        int n = numElems = stack != null ? stack.size() : 0;
        if (numElems != this.pattern.length) {
            return -1;
        }
        for (int pos = numElems - 1; pos >= 0; --pos) {
            if (((Node)stack.get(pos)).getName().equals(this.pattern[pos])) continue;
            return -1;
        }
        return numElems;
    }

    @Override
    public String getName() {
        return this.ruleName;
    }
}

