/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;

public class HadoopDefaultAuthenticator
implements HiveAuthenticationProvider {
    protected String userName;
    protected List<String> groupNames;
    protected Configuration conf;

    @Override
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        UserGroupInformation ugi = null;
        try {
            ugi = Utils.getUGI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ugi == null) {
            throw new RuntimeException("Can not initialize HadoopDefaultAuthenticator.");
        }
        this.userName = ugi.getShortUserName();
        if (ugi.getGroupNames() != null) {
            this.groupNames = Arrays.asList(ugi.getGroupNames());
        }
    }

    @Override
    public void destroy() throws HiveException {
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setSessionState(SessionState ss) {
    }
}

