/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedUDAFs;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarDecimalComplete;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarDoubleComplete;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarFinal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarLongComplete;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarPartial2;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarTimestampComplete;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="stddev_samp", value="_FUNC_(x) - Returns the sample standard deviation of a set of numbers.\nIf applied to an empty set: NULL is returned.\nIf applied to a set with a single element: NULL is returned.\nOtherwise it computes: sqrt(var_samp(x))")
public class GenericUDAFStdSample
extends GenericUDAFVariance {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case TIMESTAMP: 
            case DECIMAL: {
                return new GenericUDAFStdSampleEvaluator();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    @VectorizedUDAFs(value={VectorUDAFVarLong.class, VectorUDAFVarLongComplete.class, VectorUDAFVarDouble.class, VectorUDAFVarDoubleComplete.class, VectorUDAFVarDecimal.class, VectorUDAFVarDecimalComplete.class, VectorUDAFVarTimestamp.class, VectorUDAFVarTimestampComplete.class, VectorUDAFVarPartial2.class, VectorUDAFVarFinal.class})
    public static class GenericUDAFStdSampleEvaluator
    extends GenericUDAFVariance.GenericUDAFVarianceEvaluator {
        public static double calculateStdSampleResult(double variance, long count) {
            return Math.sqrt(variance / (double)(count - 1L));
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFVariance.GenericUDAFVarianceEvaluator.StdAgg myagg = (GenericUDAFVariance.GenericUDAFVarianceEvaluator.StdAgg)agg;
            if (myagg.count <= 1L) {
                return null;
            }
            this.getResult().set(GenericUDAFStdSampleEvaluator.calculateStdSampleResult(myagg.variance, myagg.count));
            return this.getResult();
        }
    }
}

