/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class WritableDateObjectInspector
extends AbstractPrimitiveWritableObjectInspector
implements SettableDateObjectInspector {
    public WritableDateObjectInspector() {
        super(TypeInfoFactory.dateTypeInfo);
    }

    @Override
    public DateWritableV2 getPrimitiveWritableObject(Object o) {
        return o == null ? null : (DateWritableV2)o;
    }

    @Override
    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : ((DateWritableV2)o).get();
    }

    @Override
    public Object copyObject(Object o) {
        return o == null ? null : new DateWritableV2((DateWritableV2)o);
    }

    @Override
    public Object set(Object o, Date d) {
        if (d == null) {
            return null;
        }
        ((DateWritableV2)o).set(d);
        return o;
    }

    @Override
    @Deprecated
    public Object set(Object o, java.sql.Date d) {
        if (d == null) {
            return null;
        }
        ((DateWritableV2)o).set(Date.ofEpochMilli(d.getTime()));
        return o;
    }

    @Override
    public Object set(Object o, DateWritableV2 d) {
        if (d == null) {
            return null;
        }
        ((DateWritableV2)o).set(d);
        return o;
    }

    @Override
    @Deprecated
    public Object create(java.sql.Date value) {
        return new DateWritableV2(Date.ofEpochMilli(value.getTime()));
    }

    @Override
    public Object create(Date d) {
        return new DateWritableV2(d);
    }
}

