/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.parquet;

import com.splunk.datasource.parquet.converter.Group;
import com.splunk.datasource.parquet.converter.JsonRecordConverter;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class JsonReadSupport
extends ReadSupport<Group> {
    private static Logger gLogger = Logger.getLogger(JsonReadSupport.class);

    public ReadSupport.ReadContext init(Configuration conf, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String partialSchemaString = conf.get("parquet.read.schema");
        MessageType requestedProjection = JsonReadSupport.getSchemaForRead((MessageType)fileSchema, (String)partialSchemaString);
        return new ReadSupport.ReadContext(requestedProjection);
    }

    public RecordMaterializer<Group> prepareForRead(Configuration conf, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        String style = conf.get("parquet.read.style", "");
        if (style.equals("hive") || style.equals("pig") || style.equals("avro")) {
            // empty if block
        }
        return new JsonRecordConverter(readContext.getRequestedSchema());
    }
}

