/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.mr.SplunkMR;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Logger;

public class AsyncMRJob
extends Job
implements Runnable {
    private static Logger gLogger = Logger.getLogger(AsyncMRJob.class);
    JobState _state = JobState.NEW;
    RunningJob _rj = null;
    JobClient _jc = null;
    Thread _th = null;
    Throwable _err = null;
    long _submitTime = 0L;

    public AsyncMRJob(Configuration conf, String jobName) throws IOException {
        super(conf, jobName);
    }

    public synchronized boolean isSubmitted() {
        return this._state == JobState.SUBMITTED;
    }

    public boolean isComplete() throws IOException {
        try {
            return this.isSubmitted() && super.isComplete();
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    public Throwable getError() {
        return this._err;
    }

    public RunningJob getRunningJob() {
        return this._rj;
    }

    public JobClient getJC() {
        return this._jc;
    }

    public void submit() {
        this.submit(true);
    }

    public void join() throws InterruptedException {
        if (this._th != null) {
            this._th.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(boolean async) {
        AsyncMRJob asyncMRJob = this;
        synchronized (asyncMRJob) {
            if (this._state != JobState.NEW) {
                return;
            }
            if (this._th == null) {
                this._th = new Thread(this);
                this._th.start();
            }
        }
        if (async) {
            return;
        }
        try {
            this._th.join();
        }
        catch (InterruptedException e) {
            gLogger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public TaskReport[] getMapTaskReports() throws IOException {
        if (!this.isSubmitted() || this._jc == null) {
            return new TaskReport[0];
        }
        return this._jc.getMapTaskReports(JobID.forName((String)this.getJobID().toString()));
    }

    public TaskReport[] getSetupTaskReports() throws IOException {
        if (!this.isSubmitted() || this._jc == null || SplunkMR.isYarn(this.getConfiguration())) {
            return new TaskReport[0];
        }
        return this._jc.getSetupTaskReports(JobID.forName((String)this.getJobID().toString()));
    }

    public TaskReport[] getCleanupTaskReports() throws IOException {
        if (!this.isSubmitted() || this._jc == null || SplunkMR.isYarn(this.getConfiguration())) {
            return new TaskReport[0];
        }
        return this._jc.getCleanupTaskReports(JobID.forName((String)this.getJobID().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object jid;
        gLogger.info((Object)String.format("AsyncMRJob job.name=%s running ... ", this.getJobName()));
        AsyncMRJob asyncMRJob = this;
        synchronized (asyncMRJob) {
            if (this._state != JobState.NEW) {
                gLogger.warn((Object)("AsyncMRJob cannot submit a job in given state=" + (Object)((Object)this._state) + ", job.name=" + this.getJobName()));
                return;
            }
            this._state = JobState.SUBMITTING;
        }
        try {
            gLogger.info((Object)String.format("Submitting job.name=%s ...", this.getJobName()));
            this._submitTime = System.currentTimeMillis();
            super.submit();
            gLogger.info((Object)String.format("Done submitting job.name=%s, url=%s", this.getJobName(), this.getTrackingURL()));
            jid = JobID.forName((String)this.getJobID().toString());
            this._jc = SplunkMR.getJobClient((Configuration)this.conf, this);
            this._rj = this._jc.getJob(jid);
        }
        catch (Throwable e) {
            this._err = e;
            gLogger.error((Object)e.getMessage(), e);
        }
        finally {
            jid = this;
            synchronized (jid) {
                this._state = this._err == null ? JobState.SUBMITTED : JobState.FAILED;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws InterruptedException, IOException {
        gLogger.info((Object)("start killing MR job id=" + this.getJobID() + ", job.name=" + this.getJobName() + ", _state=" + (Object)((Object)this._state)));
        AsyncMRJob asyncMRJob = this;
        synchronized (asyncMRJob) {
            if (this._state == JobState.KILLED || this._state == JobState.FAILED) {
                return;
            }
            while (this._state == JobState.SUBMITTING) {
                this.wait(1000L);
            }
            if (this._rj != null) {
                this._rj.killJob();
            }
            this._state = JobState.KILLED;
        }
        gLogger.info((Object)("finished killing MR job id=" + this.getJobID() + ", job.name=" + this.getJobName()));
    }

    public long getSubmitTime() {
        return this._submitTime;
    }

    public static enum JobState {
        NEW,
        SUBMITTING,
        SUBMITTED,
        KILLED,
        FAILED;

    }
}

