/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.merge;

import com.splunk.mr.cache.CacheMerger;
import com.splunk.mr.cache.merge.MergeeTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.conf.Configuration;

public class MergeDecider {
    public static final String MAX_MERGEE_SIZE = "splunk.search.cache.maximum.merge.item.size";
    public static final String AUTO_INCLUDE_SIZE = "splunk.search.cache.merge.auto.include.size";
    public static final String MAX_MERGEES_PER_MERGE = "splunk.search.cache.merge.max.items.per.merge";
    public static final String MIN_MERGEES_FOR_MERGE = "splunk.search.cache.merge.min.items.to.merge";
    public static final String COMPACTION_RATIO = "splunk.search.cache.merge.compaction.ratio";
    public static final String[] KEYS = new String[]{"splunk.search.cache.maximum.merge.item.size", "splunk.search.cache.merge.auto.include.size", "splunk.search.cache.merge.max.items.per.merge", "splunk.search.cache.merge.min.items.to.merge", "splunk.search.cache.merge.compaction.ratio"};
    private static final Map<String, String> defaults = new HashMap<String, String>();
    private Map<String, String> props;

    public MergeDecider(Map<String, String> props) {
        this.props = props;
    }

    public MergeDecision getMerges(SortedSet<CacheMerger.Mergee> sourceMergees) {
        Set<CacheMerger.Mergee> merge;
        ArrayList<CacheMerger.Mergee> mergees = new ArrayList<CacheMerger.Mergee>(new MergeeTree((Collection<CacheMerger.Mergee>)sourceMergees));
        List<CacheMerger.Mergee> tooLarge = this.getTooLargeToMerge(mergees);
        mergees.removeAll(tooLarge);
        ArrayList<Set<CacheMerger.Mergee>> merges = new ArrayList<Set<CacheMerger.Mergee>>();
        while (!(merge = this.getMerge(mergees)).isEmpty()) {
            merges.add(merge);
            mergees.removeAll(merge);
        }
        return new MergeDecision(merges, tooLarge);
    }

    private Set<CacheMerger.Mergee> getMerge(List<CacheMerger.Mergee> mergees) {
        List<CacheMerger.Mergee> contenders = new ArrayList<CacheMerger.Mergee>();
        contenders.addAll(this.filterBySizeMatchingComactionRatio(mergees));
        contenders.addAll(this.contenderIfSmallEnough(mergees));
        contenders = this.trimContendersByMaxContenderCount(contenders);
        if (this.isEnoughContendersToMerge(contenders)) {
            return new HashSet<CacheMerger.Mergee>(contenders);
        }
        return Collections.emptySet();
    }

    private boolean isEnoughContendersToMerge(List<CacheMerger.Mergee> contenders) {
        return contenders.size() >= this.getInt(MIN_MERGEES_FOR_MERGE);
    }

    private List<CacheMerger.Mergee> trimContendersByMaxContenderCount(List<CacheMerger.Mergee> contenders) {
        int maxMergees = this.getInt(MAX_MERGEES_PER_MERGE);
        if (maxMergees > contenders.size()) {
            maxMergees = contenders.size();
        }
        return contenders.subList(0, maxMergees);
    }

    private List<CacheMerger.Mergee> contenderIfSmallEnough(List<CacheMerger.Mergee> mergees) {
        ArrayList<CacheMerger.Mergee> contenders = new ArrayList<CacheMerger.Mergee>();
        for (CacheMerger.Mergee m : mergees) {
            if (m.size > this.getLong(AUTO_INCLUDE_SIZE)) continue;
            contenders.add(m);
        }
        return contenders;
    }

    private List<CacheMerger.Mergee> getTooLargeToMerge(List<CacheMerger.Mergee> mergees) {
        ArrayList<CacheMerger.Mergee> tooLarge = new ArrayList<CacheMerger.Mergee>();
        for (CacheMerger.Mergee m : mergees) {
            if (m.size <= this.getLong(MAX_MERGEE_SIZE)) continue;
            tooLarge.add(m);
        }
        return tooLarge;
    }

    private int getInt(String key) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (Exception e) {
            return Integer.parseInt(defaults.get(key));
        }
    }

    private long getLong(String key) {
        try {
            return Long.parseLong(this.getProperty(key));
        }
        catch (Exception e) {
            return Long.parseLong(defaults.get(key));
        }
    }

    private double getDouble(String key) {
        try {
            return Double.parseDouble(this.getProperty(key));
        }
        catch (Exception e) {
            return Double.parseDouble(defaults.get(key));
        }
    }

    private String getProperty(String key) {
        String value = this.props.get(key);
        return value == null ? defaults.get(key) : value;
    }

    private List<CacheMerger.Mergee> filterBySizeMatchingComactionRatio(List<CacheMerger.Mergee> mergees) {
        ArrayList<CacheMerger.Mergee> contenders = new ArrayList<CacheMerger.Mergee>();
        long[] sums = MergeDecider.getSums(mergees);
        int i = 0;
        boolean addMergees = false;
        for (CacheMerger.Mergee m : mergees) {
            if (!addMergees) {
                int next = i + 1;
                if (next < sums.length && (double)sums[next] >= (double)m.size * this.getDouble(COMPACTION_RATIO)) {
                    addMergees = true;
                }
                ++i;
            }
            if (!addMergees) continue;
            contenders.add(m);
        }
        return contenders;
    }

    static long[] getSums(Iterable<CacheMerger.Mergee> mergees) {
        long totalSum = 0L;
        int length = 0;
        for (CacheMerger.Mergee m : mergees) {
            totalSum += m.size;
            ++length;
        }
        long[] sums = new long[length];
        int i = 0;
        long sum = 0L;
        for (CacheMerger.Mergee m : mergees) {
            sums[i] = totalSum - sum;
            sum += m.size;
            ++i;
        }
        return sums;
    }

    public static MergeDecider create(final Configuration conf) {
        return new MergeDecider((Map<String, String>)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                for (String key : KEYS) {
                    this.put(key, conf.get(key, null));
                }
            }
        });
    }

    static {
        defaults.put(MAX_MERGEE_SIZE, "33554432");
        defaults.put(AUTO_INCLUDE_SIZE, "0");
        defaults.put(MAX_MERGEES_PER_MERGE, "2147483647");
        defaults.put(MIN_MERGEES_FOR_MERGE, "2");
        defaults.put(COMPACTION_RATIO, "1.0");
    }

    public static class MergeDecision {
        private final List<Set<CacheMerger.Mergee>> merges;
        private final List<CacheMerger.Mergee> tooLarge;

        public MergeDecision(List<Set<CacheMerger.Mergee>> merges, List<CacheMerger.Mergee> tooLarge) {
            this.merges = merges;
            this.tooLarge = tooLarge;
        }

        public List<Set<CacheMerger.Mergee>> getMerges() {
            return this.merges;
        }

        public List<CacheMerger.Mergee> getTooLargeToMerge() {
            return this.tooLarge;
        }
    }
}

