/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.Bucket;
import com.splunk.sdk.SplunkMiniSDK;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ClusterSlaveBucketsEndpoint {
    private static final Logger gLogger = Logger.getLogger(ClusterSlaveBucketsEndpoint.class);
    private final SplunkMiniSDK sdk;

    public ClusterSlaveBucketsEndpoint(SplunkMiniSDK sdk) {
        this.sdk = sdk;
    }

    public boolean isReplicationComplete(Bucket bucket) throws IOException {
        String endpoint = this.getClusterSlaveBucketEndpoint(bucket);
        try {
            return this.sdk.get(endpoint, new String[0]).firstEntry().path("content").path("status").getValueAsText().equals("Complete");
        }
        catch (SplunkMiniSDK.SplunkResponseException e) {
            gLogger.warn((Object)("Exception response when calling cluster endpoint=" + endpoint + "for " + bucket + " raw_response=" + e.getResponse().raw()));
            throw e;
        }
    }

    private String getClusterSlaveBucketEndpoint(Bucket bucket) {
        return "/services/cluster/slave/buckets/" + ClusterSlaveBucketsEndpoint.getEndpointBucketIdentifier(bucket);
    }

    public static String getEndpointBucketIdentifier(Bucket bucket) {
        return bucket.getIndex() + "~" + bucket.getNumber() + "~" + bucket.getServerGuid();
    }
}

