/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.Bucket;
import com.splunk.roll.BucketName;
import com.splunk.roll.PathResolver;
import com.splunk.roll.util.PathFilterU;
import com.splunk.roll.util.TimeRange;
import com.splunk.util.LazySeq;
import com.splunk.util.PathGenerator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public class PathResolverV1
extends PathResolver {
    private static final long ONE_WEEK_IN_SEC = 604800L;
    public static final long DEFAULT_EARLY_MOD_TIME = 604800L;
    public static final String CONF_EARLY_MOD_TIME = "splunk.roll.path.resolver.1.early-mod-time";
    public static final int VERSION = 1;
    private final long earlyModTime;

    public PathResolverV1(Path rollRoot, long earlyModTime) {
        super(rollRoot, 1);
        this.earlyModTime = earlyModTime;
    }

    @Override
    protected String doResolvePath(Bucket b, String versionedRoot) {
        long earliest = b.getEarliest().getTime();
        long moddedEarlyTime = earliest - earliest % this.earlyModTime;
        return versionedRoot + "/" + b.getServerGuid() + "/" + b.getIndex() + "/" + this.earlyModTime + "/" + moddedEarlyTime + "/" + PathResolver.getNormalizedBucketName(b.getName());
    }

    @Override
    public Iterable<Bucket.RemoteBucket> doResolveBuckets(final FileSystem fs, final String index, final TimeRange range, final String versionedRootPath) {
        return new Iterable<Bucket.RemoteBucket>(){

            @Override
            public Iterator<Bucket.RemoteBucket> iterator() {
                return new BucketIterator(fs, index, range, versionedRootPath);
            }
        };
    }

    private static class BucketTimeRangeFilter
    implements PathFilter {
        private TimeRange range;

        public BucketTimeRangeFilter(TimeRange range) {
            this.range = range;
        }

        public boolean accept(Path path) {
            String bucketName = path.getName();
            TimeRange bucketRange = new Bucket(new BucketName(bucketName), null, null).getTimeRange();
            return this.range.overlaps(bucketRange);
        }
    }

    public static class BucketIterator
    implements Iterator<Bucket.RemoteBucket> {
        private static final Logger gLogger = Logger.getLogger(BucketIterator.class);
        private final LazySeq<FileStatus> serverGuids;
        private final LazySeq<FileStatus> indexes;
        private final LazySeq<FileStatus> buckets;
        boolean foundNext = false;
        private Bucket.RemoteBucket next;

        public BucketIterator(FileSystem fs, String index, TimeRange timeRange, String versionedRootPath) {
            HashMap<Integer, PathFilter> pathFilters = new HashMap<Integer, PathFilter>();
            int serverGuidLevel = 1;
            int indexLevel = 2;
            int bucketLevel = 5;
            if (index != null) {
                pathFilters.put(indexLevel, new PathFilterU.NameFilter(index));
            }
            pathFilters.put(bucketLevel, new BucketTimeRangeFilter(timeRange));
            int levels = 5;
            List<LazySeq<FileStatus>> chain = PathGenerator.chain(fs, new Path(versionedRootPath), levels, pathFilters);
            this.serverGuids = chain.get(serverGuidLevel);
            this.indexes = chain.get(indexLevel);
            this.buckets = chain.get(bucketLevel);
        }

        @Override
        public boolean hasNext() {
            if (!this.foundNext) {
                this.findNext();
            }
            return this.next != null;
        }

        private void findNext() {
            this.next = null;
            try {
                if (this.buckets.hasMore()) {
                    FileStatus bucket = this.buckets.getHead();
                    String bucketName = bucket.getPath().getName();
                    this.next = new Bucket.RemoteBucket(bucket.getPath(), new BucketName(bucketName), this.indexes.getHead().getPath().getName(), this.serverGuids.getHead().getPath().getName());
                }
            }
            catch (IOException e) {
                gLogger.warn((Object)("Error when iterating over buckets: " + e));
                this.next = null;
            }
            finally {
                this.foundNext = true;
            }
        }

        @Override
        public Bucket.RemoteBucket next() {
            Bucket.RemoteBucket n = this.next;
            this.findNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

