/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll.util;

import com.splunk.util.MapUtil;
import com.splunk.util.TimeUtils;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class OutputUtil {
    private static final Logger gLogger = Logger.getLogger(OutputUtil.class);
    private static ObjectMapper jsonMapper = new ObjectMapper();

    public static synchronized void writeMap(Logger loggerOrNull, String prefix, Map<String, String> m) throws IOException {
        OutputUtil.writeMap(loggerOrNull, prefix, m, false);
    }

    public static synchronized void writeMap(Logger loggerOrNull, String prefix, Map<String, String> m, boolean pipeCheck) throws IOException {
        String _raw = prefix + OutputUtil.kvSeparated(m);
        if (loggerOrNull != null) {
            if (pipeCheck) {
                loggerOrNull.debug((Object)_raw);
            } else {
                loggerOrNull.info((Object)_raw);
            }
        }
        OutputUtil.writeMap(prefix, _raw, m, pipeCheck);
    }

    public static synchronized void writeMap(Logger logger, Throwable ex, String prefix, Map<String, String> m) throws IOException {
        String _raw = prefix + OutputUtil.kvSeparated(m);
        logger.warn((Object)_raw, ex);
        OutputUtil.writeMap(prefix, _raw, m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMap(String prefix, String raw, Map<String, String> m, boolean pipeCheck) throws IOException {
        MapUtil.conditionalPut(m, "_time", TimeUtils.getSplunkTime());
        MapUtil.conditionalPut(m, "_raw", raw);
        MapUtil.conditionalPut(m, "prefix", prefix);
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(FileDescriptor.out));
            IOUtils.write((byte[])jsonMapper.writeValueAsBytes(m), (OutputStream)out);
            IOUtils.write((String)"\n", (OutputStream)out);
            ((OutputStream)out).flush();
        }
        catch (IOException e) {
            String message = "Unable to write to parent process. The search may have been terminated. Message:\"" + raw + "\"";
            if (pipeCheck) {
                gLogger.warn((Object)message, (Throwable)e);
                throw new UnableToWriteToParentProcessException(e.getMessage());
            }
            gLogger.debug((Object)message, (Throwable)e);
        }
    }

    public static String kvSeparated(Map<String, String> m) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : m.entrySet()) {
            sb.append(e.getKey());
            sb.append("=");
            sb.append(OutputUtil.escape(e.getValue()));
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String escape(String s) {
        try {
            return jsonMapper.writeValueAsString((Object)s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class UnableToWriteToParentProcessException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public UnableToWriteToParentProcessException(String message) {
            super(message);
        }
    }
}

