/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.s2s;

import com.splunk.s2s.S2SString;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class S2SUtil {
    public static final S2SString[] PREDEFINED_STRINGS = new S2SString[]{new S2SString("_subsecond"), new S2SString("date_second"), new S2SString("date_minute"), new S2SString("date_hour"), new S2SString("date_year"), new S2SString("date_month"), new S2SString("date_mday"), new S2SString("date_wday"), new S2SString("date_zone"), new S2SString("sunday"), new S2SString("monday"), new S2SString("tuesday"), new S2SString("wednesday"), new S2SString("thursday"), new S2SString("friday"), new S2SString("saturday"), new S2SString("january"), new S2SString("february"), new S2SString("march"), new S2SString("april"), new S2SString("may"), new S2SString("june"), new S2SString("july"), new S2SString("august"), new S2SString("september"), new S2SString("october"), new S2SString("november"), new S2SString("december"), new S2SString("local"), new S2SString("punct"), new S2SString("timestartpos"), new S2SString("timeendpos"), new S2SString("_indextime"), new S2SString("-60"), new S2SString("-120"), new S2SString("-180"), new S2SString("-240"), new S2SString("-300"), new S2SString("-360"), new S2SString("-420"), new S2SString("-480"), new S2SString("-540"), new S2SString("-600"), new S2SString("-660"), new S2SString("meta"), new S2SString("truncated"), new S2SString("timestamp"), new S2SString("invalid"), new S2SString("none"), new S2SString("eet"), new S2SString("elt"), new S2SString("ert"), new S2SString("iet"), new S2SString("ilt"), new S2SString("usz"), new S2SString("nev"), new S2SString("nh"), new S2SString("ns"), new S2SString("nst"), new S2SString("nstr"), new S2SString("null"), new S2SString("false"), new S2SString("true")};
    public static final int FIELD_NAME_INLINE_STR = 0;
    public static final int FIELD_NAME_CODE_META_DYNAMIC = 1;
    public static final int FIELD_NAME_CODE_META_PREDEFINED_STR = 2;
    public static final int FIELD_NAME_META_INLINE_STR = 3;
    public static final int FIELD_VALUE_NUMBER = 0;
    public static final int FIELD_VALUE_STR = 1;
    public static final int FIELD_VALUE_CODE_PREDEFINED_STR = 2;
    public static final int FIELD_VALUE_RAW_OFFSETLEN = 3;
    public static final int FIELD_VALUE_RAW_OFFSETLEN_REPEAT_DBLQUOTE = 4;
    public static final int FIELD_VALUE_RAW_OFFSETLEN_REPEAT_SNGLQUOTE = 5;
    public static final int FIELD_VALUE_RAW_OFFSETLEN_CESCAPING = 6;
    public static final int FIELD_VALUE_RAW_OFFSETLEN_XMLESCAPING = 7;
    public static final int FIELD_VALUE_RAW_OFFSETLEN_XMLESCAPING_W_CDATA = 8;
    public static final int FIELD_VALUE_RAW_OFFSETLEN_URLESCAPING = 9;
    public static final int S2SFLAG_HAS_RAW = 1;
    public static final int PDFLAG_HAS_STMID = 2;
    public static final int S2SFLAG_HAS_ACK_FIRST_ID = 4;
    public static final int PDFLAG_HAS_TIME = 8;
    public static final int PDFLAG_HEADERPROC_OFF_BY_DEFAULT = 16;
    public static final int PDFLAG_CHARSET_UTF8 = 32;
    public static final int PDFLAG_LINEBREAKER = 64;
    public static final int PDFLAG_DSTRX = 128;
    public static final int S2SFLAG_HAS_PUNCT = 256;
    public static final int PDFLAG_DONE = 512;
    public static final int PDFLAG_FLUSH = 1024;
    public static final int PDFLAG_RECOVEREVENT = 2048;
    public static final int PDFLAG_HAS_TIME_FIRM = 4096;
    public static final int S2SFLAG_USE_LAST_EVENTTIME = 8192;
    public static final int PDFLAG_NOT_FIRST_DATA = 16384;
    public static final int S2SFLAG_USE_LAST_INDEX = 32768;
    public static final int S2SFLAG_MASK = 65535;
    public static final int OPCODE_PEER_TIMEZONE = 255;
    public static final int OPCODE_CHANNEL_START = 254;
    public static final int OPCODE_CHANNEL_ABANDON = 253;
    public static final int OPCODE_EVENT = 252;
    public static final int OPCODE_ACK_SINGLE = 251;
    public static final int OPCODE_ACK_RANGE = 250;
    public static final int OPCODE_START_ZLIB = 249;
    public static final int FLAG_DONT_INDEX_UNSQUASHED = 64;
    public static final String CAPABILITIES_KEY = "__s2s_capabilities";
    public static final String AUTHENTICATION_TOKEN_KEY = "__s2s_token";
    public static final String S2SEVENTID_KEY = "__s2s_eventId";
    public static final String CAPABILITY_COMPRESSION = "compression";
    public static final String CAPABILITY_CAP_FLUSH_KEY = "cap_flush_key";
    public static final String CAPABILITY_ACK = "ack";
    public static final String CAPABILITY_SUPPORTS_ACK_SETTING_ON_IDX = "supports_ack_setting_on_idx";
    public static final String CAPABILITY_NEW_S2S_VERSION = "v4";
    public static final String CAPABILITY_NEW_S2S_CHANNEL_LIMIT = "channel_limit";
    public static final String CAPABILITY_CLIENT_CAN_RCV_HB = "cli_can_rcv_hb";
    public static final String CAPABILITY_IDX_CAN_SEND_HB = "idx_can_send_hb";
    public static final String CAPABILITY_ENABLED = "1";
    public static final String CAPABILITY_DISABLED = "0";

    public static long readBase128(InputStream in) throws IOException {
        long x;
        int shiftBits;
        long result;
        block5: {
            result = 0L;
            shiftBits = 0;
            do {
                if ((x = (long)in.read()) < 0L) {
                    throw new EOFException();
                }
                if (x < 128L) break block5;
                result |= x - 128L << shiftBits;
            } while ((shiftBits = (int)((short)(shiftBits + 7))) < 64);
            throw new RuntimeException("Base128 overflow shiftBits=" + shiftBits);
        }
        if (shiftBits == 0) {
            result = x;
        } else {
            if (x >= 1L << 64 - shiftBits) {
                throw new RuntimeException("Base128 overflow x=" + x + ", shiftBits=" + shiftBits + ", result=" + result);
            }
            result |= x << shiftBits;
        }
        return result;
    }

    public static void writeBase128(OutputStream out, int v) throws IOException {
        S2SUtil.writeBase128(out, (long)v & 0xFFFFFFFFFFFFFFFFL);
    }

    public static void writeBase128(OutputStream out, long v) throws IOException {
        if (v > -1L && v < 128L) {
            out.write((int)v);
            return;
        }
        do {
            out.write((byte)(v & 0x7FL | 0x80L));
        } while ((v >>>= 7) >= 128L);
        out.write((byte)v);
    }

    public static int readInt(InputStream in) throws IOException {
        int result = in.read() & 0xFF;
        result <<= 8;
        result |= in.read() & 0xFF;
        result <<= 8;
        result |= in.read() & 0xFF;
        result <<= 8;
        return result |= in.read() & 0xFF;
    }

    public static void readFully(InputStream in, byte[] bytes) throws IOException {
        S2SUtil.readFully(in, bytes, 0, bytes.length);
    }

    public static void readFully(InputStream in, byte[] bytes, int off, int len) throws IOException {
        int tmp;
        if (len + off > bytes.length) {
            throw new IllegalArgumentException("len + off > buffer.length, (" + len + "+" + off + ") > " + bytes.length);
        }
        for (int r = in.read(bytes, off, len); r < len; r += tmp) {
            if (r < 0) {
                throw new EOFException();
            }
            tmp = in.read(bytes, off + r, len - r);
            if (tmp >= 0) continue;
            throw new EOFException();
        }
    }

    public static String getNullTerminatedString(byte[] tmp) {
        int off = 0;
        for (off = 0; off < tmp.length && tmp[off] != 0; ++off) {
        }
        return new String(tmp, 0, off);
    }
}

