/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.s2s;

import com.splunk.s2s.Channel;
import com.splunk.s2s.Event;
import com.splunk.s2s.S2SListener;
import com.splunk.s2s.S2SUtil;
import com.splunk.s2s.TCPSignature;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;

public class StreamingS2S
implements Runnable {
    private static final Logger gLogger = Logger.getLogger(StreamingS2S.class);
    ArrayList<Channel> _channels = new ArrayList(500);
    InputStream _in = null;
    S2SListener _listener = null;
    boolean _done = false;
    TCPSignature _fwdSignature = null;

    public StreamingS2S(TCPSignature fwdSig, InputStream in, S2SListener listener) {
        this._fwdSignature = fwdSig;
        this._in = in;
        this._listener = listener;
    }

    public Channel getChannel(long id) {
        return this._channels.get((int)id);
    }

    public void terminate() {
        this._done = true;
    }

    @Override
    public void run() {
        this._listener.begin();
        try {
            while (!this._done) {
                this.readNext();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._listener.finish();
        }
        this._done = true;
    }

    protected void abandonChannel() throws IOException {
        int cid = (int)S2SUtil.readBase128(this._in);
        this._listener.gotDropChannel(this._channels.get(cid));
        this._channels.set(cid, null);
    }

    protected void registerChannel() throws IOException {
        Channel c = new Channel(this._fwdSignature);
        c.readFromS2SV4(this._in, this);
        int cid = (int)c.getId();
        for (int i = this._channels.size(); i <= cid; ++i) {
            this._channels.add(null);
        }
        this._channels.set(cid, c);
        this._listener.gotChannel(c);
    }

    protected void readEvent() throws IOException {
        Event e = new Event();
        e.readFromS2SV4(this._in, this);
        if (!e.getChannel().isControlChannel()) {
            this._listener.gotEvent(e);
        } else {
            this._listener.gotControlEvent(e);
        }
    }

    protected void readAcks(boolean range) throws IOException {
        long start;
        long end = start = S2SUtil.readBase128(this._in);
        if (range) {
            end = S2SUtil.readBase128(this._in);
        }
        this._listener.gotAck(start, end);
    }

    protected void readNext() throws IOException {
        int opCode = this._in.read();
        switch (opCode) {
            case -1: {
                throw new EOFException();
            }
            case 254: {
                this.registerChannel();
                break;
            }
            case 253: {
                this.abandonChannel();
                break;
            }
            case 252: {
                this.readEvent();
                break;
            }
            case 249: {
                this._in = new GZIPInputStream(this._in);
                break;
            }
            case 255: {
                int tzLength = (int)S2SUtil.readBase128(this._in);
                byte[] tzBytes = new byte[tzLength];
                S2SUtil.readFully(this._in, tzBytes);
                this._listener.gotTimezone(tzBytes);
                break;
            }
            case 250: {
                this.readAcks(true);
                break;
            }
            case 251: {
                this.readAcks(false);
                break;
            }
            default: {
                throw new IOException("Unknown opcode=" + opCode);
            }
        }
    }
}

