/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.search;

import com.splunk.search.ParseNodeCmp;
import com.splunk.search.ParseNodeGroup;
import com.splunk.search.ParseNodePhrase;
import com.splunk.search.ParseNodeTerm;
import com.splunk.search.SearchContext;
import java.util.Map;

public abstract class ParseNode {
    public boolean matches(SearchContext sc, boolean defaultLeafResult) {
        return defaultLeafResult;
    }

    public boolean isLeaf() {
        return false;
    }

    public static ParseNode getByType(Type type) {
        if (type == Type.term) {
            return new ParseNodeTerm();
        }
        if (type == Type.phrase) {
            return new ParseNodePhrase();
        }
        if (type == Type.group) {
            return new ParseNodeGroup();
        }
        if (type == Type.cmp) {
            return new ParseNodeCmp();
        }
        throw new IllegalArgumentException("Unknown node type=" + (Object)((Object)type) + ".");
    }

    public abstract void initFrom(Map<String, Object> var1);

    public abstract Type getType();

    public static void checkNodeType(Map<String, Object> data, Type expected) {
        String type = String.valueOf(data.get("type"));
        if (type.compareToIgnoreCase(expected.toString()) != 0) {
            throw new IllegalArgumentException("Invalid type, the expected type=" + (Object)((Object)expected) + ", got type=" + type + ".");
        }
    }

    public static enum Type {
        term,
        phrase,
        group,
        cmp;

    }
}

