/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codecommit.AWSCodeCommitAsync;
import com.amazonaws.services.codecommit.AWSCodeCommitClient;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesRequest;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesResult;
import com.amazonaws.services.codecommit.model.CreateBranchRequest;
import com.amazonaws.services.codecommit.model.CreateRepositoryRequest;
import com.amazonaws.services.codecommit.model.CreateRepositoryResult;
import com.amazonaws.services.codecommit.model.DeleteRepositoryRequest;
import com.amazonaws.services.codecommit.model.DeleteRepositoryResult;
import com.amazonaws.services.codecommit.model.GetBranchRequest;
import com.amazonaws.services.codecommit.model.GetBranchResult;
import com.amazonaws.services.codecommit.model.GetRepositoryRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryResult;
import com.amazonaws.services.codecommit.model.ListBranchesRequest;
import com.amazonaws.services.codecommit.model.ListBranchesResult;
import com.amazonaws.services.codecommit.model.ListRepositoriesRequest;
import com.amazonaws.services.codecommit.model.ListRepositoriesResult;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSCodeCommitAsyncClient
extends AWSCodeCommitClient
implements AWSCodeCommitAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCodeCommitAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSCodeCommitAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<BatchGetRepositoriesResult> batchGetRepositoriesAsync(final BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        return this.executorService.submit(new Callable<BatchGetRepositoriesResult>(){

            @Override
            public BatchGetRepositoriesResult call() {
                return AWSCodeCommitAsyncClient.this.batchGetRepositories(batchGetRepositoriesRequest);
            }
        });
    }

    @Override
    public Future<BatchGetRepositoriesResult> batchGetRepositoriesAsync(final BatchGetRepositoriesRequest batchGetRepositoriesRequest, final AsyncHandler<BatchGetRepositoriesRequest, BatchGetRepositoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetRepositoriesResult>(){

            @Override
            public BatchGetRepositoriesResult call() throws Exception {
                BatchGetRepositoriesResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.batchGetRepositories(batchGetRepositoriesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(batchGetRepositoriesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createBranchAsync(final CreateBranchRequest createBranchRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodeCommitAsyncClient.this.createBranch(createBranchRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createBranchAsync(final CreateBranchRequest createBranchRequest, final AsyncHandler<CreateBranchRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodeCommitAsyncClient.this.createBranch(createBranchRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createBranchRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(final CreateRepositoryRequest createRepositoryRequest) {
        return this.executorService.submit(new Callable<CreateRepositoryResult>(){

            @Override
            public CreateRepositoryResult call() {
                return AWSCodeCommitAsyncClient.this.createRepository(createRepositoryRequest);
            }
        });
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(final CreateRepositoryRequest createRepositoryRequest, final AsyncHandler<CreateRepositoryRequest, CreateRepositoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateRepositoryResult>(){

            @Override
            public CreateRepositoryResult call() throws Exception {
                CreateRepositoryResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.createRepository(createRepositoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createRepositoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(final DeleteRepositoryRequest deleteRepositoryRequest) {
        return this.executorService.submit(new Callable<DeleteRepositoryResult>(){

            @Override
            public DeleteRepositoryResult call() {
                return AWSCodeCommitAsyncClient.this.deleteRepository(deleteRepositoryRequest);
            }
        });
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(final DeleteRepositoryRequest deleteRepositoryRequest, final AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRepositoryResult>(){

            @Override
            public DeleteRepositoryResult call() throws Exception {
                DeleteRepositoryResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.deleteRepository(deleteRepositoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteRepositoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetBranchResult> getBranchAsync(final GetBranchRequest getBranchRequest) {
        return this.executorService.submit(new Callable<GetBranchResult>(){

            @Override
            public GetBranchResult call() {
                return AWSCodeCommitAsyncClient.this.getBranch(getBranchRequest);
            }
        });
    }

    @Override
    public Future<GetBranchResult> getBranchAsync(final GetBranchRequest getBranchRequest, final AsyncHandler<GetBranchRequest, GetBranchResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetBranchResult>(){

            @Override
            public GetBranchResult call() throws Exception {
                GetBranchResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.getBranch(getBranchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getBranchRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryResult> getRepositoryAsync(final GetRepositoryRequest getRepositoryRequest) {
        return this.executorService.submit(new Callable<GetRepositoryResult>(){

            @Override
            public GetRepositoryResult call() {
                return AWSCodeCommitAsyncClient.this.getRepository(getRepositoryRequest);
            }
        });
    }

    @Override
    public Future<GetRepositoryResult> getRepositoryAsync(final GetRepositoryRequest getRepositoryRequest, final AsyncHandler<GetRepositoryRequest, GetRepositoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRepositoryResult>(){

            @Override
            public GetRepositoryResult call() throws Exception {
                GetRepositoryResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.getRepository(getRepositoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getRepositoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListBranchesResult> listBranchesAsync(final ListBranchesRequest listBranchesRequest) {
        return this.executorService.submit(new Callable<ListBranchesResult>(){

            @Override
            public ListBranchesResult call() {
                return AWSCodeCommitAsyncClient.this.listBranches(listBranchesRequest);
            }
        });
    }

    @Override
    public Future<ListBranchesResult> listBranchesAsync(final ListBranchesRequest listBranchesRequest, final AsyncHandler<ListBranchesRequest, ListBranchesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListBranchesResult>(){

            @Override
            public ListBranchesResult call() throws Exception {
                ListBranchesResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.listBranches(listBranchesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listBranchesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListRepositoriesResult> listRepositoriesAsync(final ListRepositoriesRequest listRepositoriesRequest) {
        return this.executorService.submit(new Callable<ListRepositoriesResult>(){

            @Override
            public ListRepositoriesResult call() {
                return AWSCodeCommitAsyncClient.this.listRepositories(listRepositoriesRequest);
            }
        });
    }

    @Override
    public Future<ListRepositoriesResult> listRepositoriesAsync(final ListRepositoriesRequest listRepositoriesRequest, final AsyncHandler<ListRepositoriesRequest, ListRepositoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRepositoriesResult>(){

            @Override
            public ListRepositoriesResult call() throws Exception {
                ListRepositoriesResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.listRepositories(listRepositoriesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listRepositoriesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateDefaultBranchAsync(final UpdateDefaultBranchRequest updateDefaultBranchRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodeCommitAsyncClient.this.updateDefaultBranch(updateDefaultBranchRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateDefaultBranchAsync(final UpdateDefaultBranchRequest updateDefaultBranchRequest, final AsyncHandler<UpdateDefaultBranchRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodeCommitAsyncClient.this.updateDefaultBranch(updateDefaultBranchRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateDefaultBranchRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateRepositoryDescriptionAsync(final UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodeCommitAsyncClient.this.updateRepositoryDescription(updateRepositoryDescriptionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateRepositoryDescriptionAsync(final UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest, final AsyncHandler<UpdateRepositoryDescriptionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodeCommitAsyncClient.this.updateRepositoryDescription(updateRepositoryDescriptionRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateRepositoryDescriptionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateRepositoryNameAsync(final UpdateRepositoryNameRequest updateRepositoryNameRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodeCommitAsyncClient.this.updateRepositoryName(updateRepositoryNameRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateRepositoryNameAsync(final UpdateRepositoryNameRequest updateRepositoryNameRequest, final AsyncHandler<UpdateRepositoryNameRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodeCommitAsyncClient.this.updateRepositoryName(updateRepositoryNameRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateRepositoryNameRequest, result);
                return result;
            }
        });
    }
}

