/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.DeploymentInfo;
import com.amazonaws.services.codedeploy.model.transform.DeploymentOverviewJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.ErrorInformationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DeploymentInfoJsonMarshaller {
    private static DeploymentInfoJsonMarshaller instance;

    public void marshall(DeploymentInfo deploymentInfo, JSONWriter jsonWriter) {
        if (deploymentInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (deploymentInfo.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(deploymentInfo.getApplicationName());
            }
            if (deploymentInfo.getDeploymentGroupName() != null) {
                jsonWriter.key("deploymentGroupName").value(deploymentInfo.getDeploymentGroupName());
            }
            if (deploymentInfo.getDeploymentConfigName() != null) {
                jsonWriter.key("deploymentConfigName").value(deploymentInfo.getDeploymentConfigName());
            }
            if (deploymentInfo.getDeploymentId() != null) {
                jsonWriter.key("deploymentId").value(deploymentInfo.getDeploymentId());
            }
            if (deploymentInfo.getRevision() != null) {
                jsonWriter.key("revision");
                RevisionLocationJsonMarshaller.getInstance().marshall(deploymentInfo.getRevision(), jsonWriter);
            }
            if (deploymentInfo.getStatus() != null) {
                jsonWriter.key("status").value(deploymentInfo.getStatus());
            }
            if (deploymentInfo.getErrorInformation() != null) {
                jsonWriter.key("errorInformation");
                ErrorInformationJsonMarshaller.getInstance().marshall(deploymentInfo.getErrorInformation(), jsonWriter);
            }
            if (deploymentInfo.getCreateTime() != null) {
                jsonWriter.key("createTime").value(deploymentInfo.getCreateTime());
            }
            if (deploymentInfo.getStartTime() != null) {
                jsonWriter.key("startTime").value(deploymentInfo.getStartTime());
            }
            if (deploymentInfo.getCompleteTime() != null) {
                jsonWriter.key("completeTime").value(deploymentInfo.getCompleteTime());
            }
            if (deploymentInfo.getDeploymentOverview() != null) {
                jsonWriter.key("deploymentOverview");
                DeploymentOverviewJsonMarshaller.getInstance().marshall(deploymentInfo.getDeploymentOverview(), jsonWriter);
            }
            if (deploymentInfo.getDescription() != null) {
                jsonWriter.key("description").value(deploymentInfo.getDescription());
            }
            if (deploymentInfo.getCreator() != null) {
                jsonWriter.key("creator").value(deploymentInfo.getCreator());
            }
            if (deploymentInfo.getIgnoreApplicationStopFailures() != null) {
                jsonWriter.key("ignoreApplicationStopFailures").value(deploymentInfo.getIgnoreApplicationStopFailures());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentInfoJsonMarshaller();
        }
        return instance;
    }
}

