/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.transform.GitHubLocationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.S3LocationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RevisionLocationJsonMarshaller {
    private static RevisionLocationJsonMarshaller instance;

    public void marshall(RevisionLocation revisionLocation, JSONWriter jsonWriter) {
        if (revisionLocation == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (revisionLocation.getRevisionType() != null) {
                jsonWriter.key("revisionType").value(revisionLocation.getRevisionType());
            }
            if (revisionLocation.getS3Location() != null) {
                jsonWriter.key("s3Location");
                S3LocationJsonMarshaller.getInstance().marshall(revisionLocation.getS3Location(), jsonWriter);
            }
            if (revisionLocation.getGitHubLocation() != null) {
                jsonWriter.key("gitHubLocation");
                GitHubLocationJsonMarshaller.getInstance().marshall(revisionLocation.getGitHubLocation(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RevisionLocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RevisionLocationJsonMarshaller();
        }
        return instance;
    }
}

