/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Problem;
import com.amazonaws.services.devicefarm.model.UniqueProblem;
import com.amazonaws.services.devicefarm.model.transform.ProblemJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class UniqueProblemJsonMarshaller {
    private static UniqueProblemJsonMarshaller instance;

    public void marshall(UniqueProblem uniqueProblem, JSONWriter jsonWriter) {
        if (uniqueProblem == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Problem> problemsList;
            jsonWriter.object();
            if (uniqueProblem.getMessage() != null) {
                jsonWriter.key("message").value(uniqueProblem.getMessage());
            }
            if ((problemsList = uniqueProblem.getProblems()) != null) {
                jsonWriter.key("problems");
                jsonWriter.array();
                for (Problem problemsListValue : problemsList) {
                    if (problemsListValue == null) continue;
                    ProblemJsonMarshaller.getInstance().marshall(problemsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static UniqueProblemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UniqueProblemJsonMarshaller();
        }
        return instance;
    }
}

