/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClient;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamResult;
import com.amazonaws.services.dynamodbv2.model.GetRecordsRequest;
import com.amazonaws.services.dynamodbv2.model.GetRecordsResult;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorRequest;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorResult;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.services.dynamodbv2.model.ListStreamsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonDynamoDBStreamsAsyncClient
extends AmazonDynamoDBStreamsClient
implements AmazonDynamoDBStreamsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonDynamoDBStreamsAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonDynamoDBStreamsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(final DescribeStreamRequest describeStreamRequest) {
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() {
                return AmazonDynamoDBStreamsAsyncClient.this.describeStream(describeStreamRequest);
            }
        });
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(final DescribeStreamRequest describeStreamRequest, final AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() throws Exception {
                DescribeStreamResult result;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.describeStream(describeStreamRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeStreamRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(final GetRecordsRequest getRecordsRequest) {
        return this.executorService.submit(new Callable<GetRecordsResult>(){

            @Override
            public GetRecordsResult call() {
                return AmazonDynamoDBStreamsAsyncClient.this.getRecords(getRecordsRequest);
            }
        });
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(final GetRecordsRequest getRecordsRequest, final AsyncHandler<GetRecordsRequest, GetRecordsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRecordsResult>(){

            @Override
            public GetRecordsResult call() throws Exception {
                GetRecordsResult result;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.getRecords(getRecordsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getRecordsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(final GetShardIteratorRequest getShardIteratorRequest) {
        return this.executorService.submit(new Callable<GetShardIteratorResult>(){

            @Override
            public GetShardIteratorResult call() {
                return AmazonDynamoDBStreamsAsyncClient.this.getShardIterator(getShardIteratorRequest);
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(final GetShardIteratorRequest getShardIteratorRequest, final AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetShardIteratorResult>(){

            @Override
            public GetShardIteratorResult call() throws Exception {
                GetShardIteratorResult result;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.getShardIterator(getShardIteratorRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getShardIteratorRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(final ListStreamsRequest listStreamsRequest) {
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() {
                return AmazonDynamoDBStreamsAsyncClient.this.listStreams(listStreamsRequest);
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(final ListStreamsRequest listStreamsRequest, final AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                ListStreamsResult result;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.listStreams(listStreamsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listStreamsRequest, result);
                return result;
            }
        });
    }
}

